//
// C++ Implementation: kpgsequence
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsequence.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpgdatabase.h"
#include "kpgschema.h"
#include "kpgsequencesfolder.h"



KPGSequence::KPGSequence(KPGSequencesFolder *parent, const QString name, pqxx::oid _oid)
 : KPGObject(parent, name, _oid)
{
	setPixmap(0, *m_pIconSequence);
	
	m_llLastValue = 0;
	m_llMinValue = 0; 
	m_llMaxValue = 0; 
	m_llCacheValue = 0; 
	m_bIsCycled = false; 
	m_iIncrementBy = 1;
}

KPGSequence::KPGSequence(KPGSequencesFolder *parent, KPGSequence *after, const QString name, pqxx::oid _oid)
 : KPGObject(parent, after, name, _oid)
{
	setPixmap(0, *m_pIconSequence);
	
	m_llLastValue = 0;
	m_llMinValue = 0; 
	m_llMaxValue = 0; 
	m_llCacheValue = 0; 
	m_bIsCycled = false; 
	m_iIncrementBy = 1;
}


KPGSequence::~KPGSequence()
{
}

void KPGSequence::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	m_strOwner = pqxxTuple["seqowner"].c_str();
	m_strACL = pqxxTuple["relacl"].c_str();
	m_strDescription = pqxxTuple["description"].c_str();
}

void KPGSequence::setSeqValues(const pqxx::result::tuple &pqxxTuple)
{
	QString strLastValue(pqxxTuple["last_value"].c_str());
    QString strMinValue(pqxxTuple["min_value"].c_str()); 
    QString strMaxValue(pqxxTuple["max_value"].c_str()); 
    QString strCacheValue(pqxxTuple["cache_value"].c_str()); 
                                
    m_llLastValue = strLastValue.toLongLong();
    m_llMinValue = strMinValue.toLongLong(); 
    m_llMaxValue = strMaxValue.toLongLong(); 
    m_llCacheValue = strCacheValue.toLongLong(); 
        
    /*pqxxTuple["last_value"].to(iLastValue);
    pqxxTuple["min_value"].to(iMinValue);
    pqxxTuple["max_value"].to(iMaxValue);
    pqxxTuple["cache_value"].to(iCacheValue);*/
    pqxxTuple["is_cycled"].to(m_bIsCycled);
    pqxxTuple["increment_by"].to(m_iIncrementBy);
}

// Refresh only view info, without childs objects
void KPGSequence::refreshItem() throw(const KPGSqlException &)
{
    // Get pointer to server for version info
    KPGSchema *pSchema = static_cast <KPGSchema *> (parent()->parent());
    KPGDatabase *pDatabase = static_cast <KPGDatabase *> (pSchema->parent());
    KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
    if(pServer->type() != nodeServer)
    {
        kdError() << "KPGSequence::refreshItem cannot find parent server." << endl;
    }
    
    // obtain sequence info
    QString strQuery("SELECT cl.oid, relname, description, pg_get_userbyid(relowner) AS seqowner, relacl ");
    strQuery.append("FROM pg_catalog.pg_class cl ");
    strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=cl.oid ");
    
    strQuery.append("WHERE cl.oid = " + QString("%1").arg(m_oid));
        
    try
    {
        pqxx::result pqxxResultSequences = connection()->runQuery(strQuery);
    
        if(pqxxResultSequences.size() != 1)
        {
            kdError() << k_funcinfo "Expect one row in result !" <<  endl;
        }
            
        setProperties(pqxxResultSequences[0]);
        
        
        if((pServer->versionMajor() >= 8) || ((pServer->versionMajor() == 7) && (pServer->versionMiddle() >= 4)))
        {           
            //-- Get seq. values
            strQuery = QString("SELECT last_value, min_value, max_value, cache_value, is_cycled, increment_by \
            FROM \"%1\".\"%2\";").arg(pSchema->text(0)).arg(pqxxResultSequences[0]["relname"].c_str());
            pqxx::result pqxxResultSeqValues = connection()->runQuery(strQuery);
                
            if (pqxxResultSeqValues.size() == 1)
            { 
                setSeqValues(pqxxResultSeqValues[0]);
            }  
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}

const pqxx::result KPGSequence::queryIoStatistics() throw(const KPGSqlException &)
{
	QString strQuery("SELECT relname, blks_read, blks_hit FROM pg_catalog.pg_statio_all_sequences WHERE relid = ");
    strQuery.append(QString("%1;").arg(m_oid));
    
    try
    {
        KPGConnection *pDbConnection = connection();
        pqxx::work pqxxXaction(*pDbConnection, "refresh sequence statistics");
        return pqxxXaction.exec(strQuery.latin1());
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}
