/***************************************************************************
                          kpgserver.h  -  description
                             -------------------
    begin                : � led 6 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGSERVER_H
#define KPGSERVER_H

#include "kpgtreeitem.h"

// forward references
class KPGConnection;
class QPixmap;
class QString;
class KPGUsersFolder;
class KPGGroupsFolder;
class KPGTablespacesFolder;
class QStringList;

/**
  * Item, that represent PostgreSQL DB server
  *
  * @author Lumir Vanek
  */
class KPGServer : public KPGTreeItem
{

public: 
	KPGServer(QListView *);
	~KPGServer();

public:
    virtual eNodeType type() const { return nodeServer; }
    bool connectToServer(const QString, const QString, const QString, const QString, const QString);
    
    // Return connection to database. All items childs to KPGDatabase tells your parents for connection
    virtual KPGConnection * connection() const { return m_pDbConnection; }
    
    pqxx::result runQuery(const QString &);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
	// This same behavior as refreshItem(), but for some objects, may be optimalized to run faster
	void smartRefresh() throw(const KPGSqlException &) ;
	
	const QString url() const;
	KPGUsersFolder * getUsersFolder() { return m_pFolderUsers; }
	KPGGroupsFolder * getGroupsFolder() { return m_pFolderGroups; }
	KPGTablespacesFolder *getTablespacesFolder() { return  m_pFolderTableSpaces; }
  	  
  	// Force PostgreSQL server to reload configuration
	bool reloadConfig();
	
	// Force PostgreSQL server to rotate log file
	bool rotateLogFile();
	
	// Cancel a backed's current query on PostgreSQL server
	bool cancelBackend(int);

	/*
	 * Functions for accessing properties
	 */
	const QString & versionInfo() const { return m_strVersionInfo; }
	
	// Return PostgreSQL server version numbers
	unsigned int versionMinor() const { return m_uiVersionMinor; }
	unsigned int versionMiddle()  const { return m_uiVersionMiddle; }
	unsigned int versionMajor()  const { return m_uiVersionMajor; }
  
  	const pqxx::result & resultDatabases() const { return m_pqxxResultDatabases; }
  
  	// Query server activity 
	pqxx::result queryActivity() throw(const KPGSqlException &);
  
protected:

    void getVersionInfo();
	void refreshDatabaseList(bool) throw(const KPGSqlException &);
  
    // PostgreSQL server version info 
    unsigned int m_uiVersionMinor;
    unsigned int m_uiVersionMiddle;
    unsigned int m_uiVersionMajor;
    
  
protected:

    KPGConnection *m_pDbConnection;
    QString m_strVersionInfo; // Info about PostgreSQL server
            
    // results that will be displaied in properties window
    pqxx::result m_pqxxResultDatabases; 
	
	KPGUsersFolder *m_pFolderUsers;
	KPGGroupsFolder *m_pFolderGroups;
	KPGTablespacesFolder *m_pFolderTableSpaces;
};

#endif
