//
// C++ Implementation: kpgtableindexesfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtableindexesfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpgdatabase.h"
#include "kpgprimarykey.h"
#include "kpgindex.h"


KPGTableIndexesFolder::KPGTableIndexesFolder(KPGTable *parent)
 : KPGTableItemsFolder(parent, i18n("Indexes"))
{
	setPixmap(0, *m_pIconFolderRed);
}

KPGTableIndexesFolder::KPGTableIndexesFolder(KPGTable *parent, KPGTableItemsFolder *after)
 : KPGTableItemsFolder(parent, after, i18n("Indexes"))
{
	setPixmap(0, *m_pIconFolderRed);
}

KPGTableIndexesFolder::~KPGTableIndexesFolder()
{
}

void KPGTableIndexesFolder::refresh(pqxx::oid oidTable) throw(const KPGSqlException &)
{
	// delete all child items (databases)
	while (QListViewItem * pItem = firstChild())
		delete pItem;
		
	// Get pointer to server for version info       table   -> tblfold-> schema ->database->server 
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (parent()->parent()->parent()->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
	
	bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	    
	// Is it 8.0 or newer ?
	if(pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
    }     
	    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
	}
	
	QString strQuery("SELECT cls.oid, cls.relname as idxname, CASE contype WHEN 'p' THEN 'Primary Key' ELSE 'Index' END AS idxtypedesc, CASE contype WHEN 'p' THEN \
despkey.description ELSE desidx.description END AS description, indkey, indisunique, indisprimary, indisclustered ");
	
	if(bVersion80_OrNewer) // tablespace info
    {
    	strQuery.append(QString(", CASE cls.reltablespace WHEN 0 THEN %1 ELSE cls.reltablespace END AS reltablespace, ts.spcname").arg(pDatabase->oidTablespace()));
	}
		
	if(bVersion81_OrNewer) 
	{
		strQuery.append(", pg_catalog.pg_size_pretty(pg_catalog.pg_relation_size(cls.oid)) AS size_pretty");
		strQuery.append(", pg_catalog.pg_relation_size(cls.oid) AS index_size");
	}
		
	strQuery.append(", pg_get_indexdef(cls.oid) AS indexdef ");
		
	strQuery.append("FROM pg_catalog.pg_index idx JOIN pg_catalog.pg_class cls ON cls.oid=indexrelid JOIN pg_am am ON am.oid=cls.relam ");
	
	strQuery.append("LEFT JOIN pg_catalog.pg_depend dep ON (dep.classid = cls.tableoid AND dep.objid = cls.oid AND dep.refobjsubid = '0') ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_constraint con ON (con.tableoid = dep.refclassid AND con.oid = dep.refobjid)   ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description desidx ON desidx.objoid=cls.oid ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description despkey ON (despkey.objoid=con.oid AND despkey.objsubid = 0) ");
	
	if(bVersion80_OrNewer)
    {
    	strQuery.append("LEFT JOIN pg_catalog.pg_tablespace ts ON CASE cls.reltablespace ");
    	strQuery.append(QString("WHEN 0 THEN %1 ELSE cls.reltablespace END=ts.oid ").arg(pDatabase->oidTablespace()));
    }
	
	strQuery.append("WHERE indrelid =  ");
	strQuery.append(QString("%1").arg(oidTable));
	strQuery.append(" ORDER BY cls.relname;");
			
	try
	{
		m_pqxxResultIndexes = connection()->runQuery(strQuery);
		
		KPGTableIndex *pTableIndex = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultIndexes.size(); ++i)
		{
			pqxx::oid oid;
			m_pqxxResultIndexes[i][0].to(oid);
			QString strType(m_pqxxResultIndexes[i]["idxtypedesc"].c_str());
										
			if(strType == "Primary Key")
			{
				if(pTableIndex == 0)
					pTableIndex = new KPGPrimaryKey(this, m_pqxxResultIndexes[i]["idxname"].c_str(), oid);
				else
					pTableIndex = new KPGPrimaryKey(this, pTableIndex, m_pqxxResultIndexes[i]["idxname"].c_str(), oid);
			}
				
			if(strType == "Index")
			{
				if(pTableIndex == 0)
					pTableIndex = new KPGIndex(this, m_pqxxResultIndexes[i]["idxname"].c_str(), oid);
				else
					pTableIndex = new KPGIndex(this, pTableIndex, m_pqxxResultIndexes[i]["idxname"].c_str(), oid);
			}
				
			pTableIndex->setProperties(m_pqxxResultIndexes[i], bVersion80_OrNewer, bVersion81_OrNewer);
			
			// Load info about index columns
			pTableIndex->refreshMapIndexKey(oidTable);
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

