//
// C++ Implementation: kpglanguageproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpglanguageproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h> 

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <ktextedit.h>
#include <kdebug.h>
#include <klocale.h>

#include "../kpglinklabel.h"
#include "../DbObjects/kpglanguage.h"
#include "../kpgutil.h"

KPGLanguagePropPage::KPGLanguagePropPage(QWidget *parent, KPGLanguage *pLanguage)
 : KPGLanguagePropPageBase(parent, "KPGLanguagePropPage")
{
  m_pLanguage = pLanguage;
  
  m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group.png"))));
  
  displayProperties();
}


KPGLanguagePropPage::~KPGLanguagePropPage()
{
}

void KPGLanguagePropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

    pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
	  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pLanguage->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
		
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pLanguage->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Language name"));
	
	//--- Is trusted
	m_pTableProperties->setText(iRow, 0, i18n("Is Trusted"));
    m_pTableProperties->setPixmap(iRow, 1, m_pLanguage->isTrusted() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n(" This is a trusted language. See under CREATE LANGUAGE what this means."));
	
	//--- ACL
	setACL(m_pLanguage->acl());
	
	//--- Language Function
	m_pTableProperties->setText(iRow, 0, i18n("Language function"));
    KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Language function" );
	pLabel->setValues(m_pLanguage->oidLanguageProc(), m_pLanguage->languageProcName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Language handler, which is a special function that is responsible for executing all functions that are written in the particular language.)"));
	
	//--- Language Validator
	m_pTableProperties->setText(iRow, 0, i18n("Language validator"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Language validator" );
	pLabel->setValues(m_pLanguage->oidValidatorProc(), m_pLanguage->validatorProcName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Language validator function that is responsible for checking the syntax and validity of new functions when they are created."));
		
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}


void KPGLanguagePropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}


void KPGLanguagePropPage::setACL(const QString &strACL)
{
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
		strAclItem.truncate(0); // clear ACL string
		}
		else
		{
		strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText( 0, (*it).grantee() );
		pItem->setText( 1, (*it).grantor() );
		
		pItem->setPixmap(2, UserIcon((*it).canUse() ? "box_checked.png" : "box_clear.png"));
			
		if((*it).canPassGrantToOther())
		{  
		pItem->setPixmap(3, UserIcon((*it).canGrantUse() ? "box_checked.png" : "box_clear.png")); 
		}
	} 
}

void KPGLanguagePropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
	// Find KPGAclItem using pItem value
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		if(pItem == (*it).getListViewItem())
		{
		// found ...
		
		switch(iColumn)
		{
			case 0:
			case 1: // do nothing on first 2 columns
				break;
			
			case 2:
				pItem->setPixmap(2, UserIcon((*it).toggleUse() ? "box_checked.png" : "box_clear.png"));
				break;
		
			case 3:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(3, UserIcon((*it).toggleGrantUse() ? "box_checked.png" : "box_clear.png"));
				
				break;
			
				
				break;
				
			default:
					kdError() << k_funcinfo << " Unexpected column !" << endl;
					break;      
		}
		
		m_pPushButtonUpdateACL->setEnabled(true);
		return;
		}
	}
}

void KPGLanguagePropPage::slotUpdateACL()
{
	QString strSQL;
	
	// Traverse all items and get their SQL's
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		strSQL.append((*it).getSQL("LANGUAGE " + KPGUtil::quotedName(m_pLanguage->text(0)) ));
	}
	
	if(!strSQL.isEmpty())
		emit sigRunWizard(strSQL);
}

// Consumes request for context menu for property table
void KPGLanguagePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpglanguageproppage.moc"
