//
// C++ Interface: kpgoperatorclassproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGOPERATORCLASSPROPPAGE_H
#define KPGOPERATORCLASSPROPPAGE_H

#include "kpgoperatorclassproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGOperatorClass;

/**
  * Operator Class properties
  *
  * @author Lumir Vanek
  */
class KPGOperatorClassPropPage : public KPGOperatorClassPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGOperatorClassPropPage(QWidget *, KPGOperatorClass *);
    ~KPGOperatorClassPropPage();

	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGOperatorClass * m_pOperatorClass;	

protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
		
signals:
	void sigSearchObject(const pqxx::oid);
	
	// Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
