/***************************************************************************
                          kpgtablecolumnproppage  -  description
                             -------------------
    begin                : So no 7 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGTABLECOLUMNPROPPAGE_H
#define KPGTABLECOLUMNPROPPAGE_H

#include "kpgtablecolumnproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGTableColumn;

/**
  * Table column property page
  *
  * @author Lumir Vanek
*/
class KPGTableColumnPropPage : public KPGTableColumnPropPageBase, public KPGAbstractPropertyPage
{
    Q_OBJECT
public:
    KPGTableColumnPropPage(QWidget *parent, KPGTableColumn *);
    ~KPGTableColumnPropPage();

	// Display properties of underlying database object
	virtual void displayProperties();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGTableColumn * m_pTableColumn;
	
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	
signals:

	void sigSearchObject(const pqxx::oid);
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
