//
// C++ Implementation: kpguserproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpguserproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpguser.h"

KPGUserPropPage::KPGUserPropPage(QWidget *parent, KPGUser * pUser)
 : KPGUserPropPageBase(parent, "KPGUserPropPage")
{
	m_pUser = pUser;
	displayProperties();
}


KPGUserPropPage::~KPGUserPropPage()
{
}

void KPGUserPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

    pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pUser->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("User name"));
	
	//--- System ID
	m_pTableProperties->setText(iRow, 0, i18n("System ID"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pUser->sysId()));
	m_pTableProperties->setText(iRow++, 2, i18n("User id (arbitrary number used to reference this user)"));
	
	
	//--- Create DB
	m_pTableProperties->setText(iRow, 0, i18n("May Create DB"));
    m_pTableProperties->setPixmap(iRow, 1, m_pUser->canCreateDb() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("User may create databases"));
	
	//--- Is superuser
	m_pTableProperties->setText(iRow, 0, i18n("Is Superuser"));
    m_pTableProperties->setPixmap(iRow, 1, m_pUser->isSuper() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("User is a superuser"));
			
	//--- May update catalog
	m_pTableProperties->setText(iRow, 0, i18n("May update catalog"));
    m_pTableProperties->setPixmap(iRow, 1, m_pUser->canCatUpd() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("User may update system catalogs. (Even a superuser may not do this unless this column is true.)"));
	
	//--- Valid until
	m_pTableProperties->setText(iRow, 0, i18n("Valid until"));
    m_pTableProperties->setText(iRow, 1, m_pUser->validUntilAsString());
	m_pTableProperties->setText(iRow++, 2, i18n("Account expiry time (only used for password authentication)"));
	
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

// Consumes request for context menu for property table
void KPGUserPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpguserproppage.moc"
