/***************************************************************************
                          kpgsqleditorsettings.cpp  -  description
                             -------------------
    begin                : Ne led 18 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgsqleditorsettings.h"

#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kcolorbutton.h>
#include <kfontdialog.h>

#include <qframe.h>
#include <qspinbox.h>

#include "kpgsqleditorsettingspage.h"

#define CONF_ENTRY_NAME_COLOR_DEFAULT_TEXT "DefaultText"
#define DFLT_VALUE_COLOR_DEFAULT_TEXT QColor( "#000000" )

#define CONF_ENTRY_NAME_COLOR_KEYWORDS "KeyWords"
#define DFLT_VALUE_COLOR_KEYWORDS QColor( "#800000" )

#define CONF_ENTRY_NAME_COLOR_DATATYPES "DataTypes"
#define DFLT_VALUE_COLOR_DATATYPES QColor( "#000080" )

#define CONF_ENTRY_NAME_COLOR_OPERATORS "Operators"
#define DFLT_VALUE_COLOR_OPERATORS QColor( "#00ffff" )

#define CONF_ENTRY_NAME_COLOR_QUOTED_STRINGS "QuotedStrings"
#define DFLT_VALUE_COLOR_QUOTED_STRINGS QColor( "#00ff00" )

#define CONF_ENTRY_NAME_COLOR_NUMBERS "Numbers"
#define DFLT_VALUE_COLOR_NUMBERS QColor( "#ffff00" )

#define CONF_ENTRY_NAME_COLOR_COMENTS "Comments"
#define DFLT_VALUE_COLOR_COMENTS QColor( "#808080" )

#define CONF_ENTRY_NAME_EDITOR_FONT "EditorFont"

KPGSqlEditorSettings::KPGSqlEditorSettings( QObject * pParent, const char * pszName )
 : KPGSettings( "SQL editor", pParent, pszName ),
   m_colorDefaultText( DFLT_VALUE_COLOR_DEFAULT_TEXT ),
   m_colorKeyWords( DFLT_VALUE_COLOR_KEYWORDS ),
   m_colorDataTypes( DFLT_VALUE_COLOR_DATATYPES ),
   m_colorOperators( DFLT_VALUE_COLOR_OPERATORS ),
   m_colorQuotedStrings( DFLT_VALUE_COLOR_QUOTED_STRINGS ),
   m_colorNumbers( DFLT_VALUE_COLOR_NUMBERS ),
   m_colorComments( DFLT_VALUE_COLOR_COMENTS ),
   m_pDialogPage(0)
{
}

void KPGSqlEditorSettings::write( KConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_DEFAULT_TEXT, m_colorDefaultText );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_KEYWORDS, m_colorKeyWords );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_DATATYPES, m_colorDataTypes );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_OPERATORS, m_colorOperators );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_QUOTED_STRINGS, m_colorQuotedStrings );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_COMENTS, m_colorComments );
	pConfig->writeEntry( CONF_ENTRY_NAME_COLOR_NUMBERS, m_colorNumbers );
    
    pConfig->writeEntry( CONF_ENTRY_NAME_EDITOR_FONT, m_Font);
}


void KPGSqlEditorSettings::read( const KConfig * pConfig )
{
	m_colorDefaultText = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_DEFAULT_TEXT, & DFLT_VALUE_COLOR_DEFAULT_TEXT );
	m_colorKeyWords = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_KEYWORDS, & DFLT_VALUE_COLOR_KEYWORDS );
	m_colorDataTypes = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_DATATYPES, & DFLT_VALUE_COLOR_DATATYPES );
	m_colorOperators = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_OPERATORS, & DFLT_VALUE_COLOR_OPERATORS );
	m_colorQuotedStrings = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_QUOTED_STRINGS, & DFLT_VALUE_COLOR_QUOTED_STRINGS );
	m_colorComments = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_COMENTS, & DFLT_VALUE_COLOR_COMENTS );
	m_colorNumbers = pConfig->readColorEntry( CONF_ENTRY_NAME_COLOR_NUMBERS, &DFLT_VALUE_COLOR_NUMBERS  );
    
    m_Font = pConfig->readFontEntry( CONF_ENTRY_NAME_EDITOR_FONT );
}


QString KPGSqlEditorSettings::dialogPageName() const
{
	return i18n( "SQL editor" );
}

QString KPGSqlEditorSettings::dialogPageHeader() const
{
	return i18n( "SQL editor properties" );
}

QString KPGSqlEditorSettings::dialogPageIcon() const
{
	return "colorize";
}


QWidget * KPGSqlEditorSettings::dialogPage( QFrame * pParent )
{
	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KPGSqlEditorSettingsPage( pParent, "text view config.dialog page" );

		// and fill its widgets with the corresponding values
		updatePage();

		connect( m_pDialogPage->m_pColorDefaultText, SIGNAL(changed(const QColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorKeyWords, SIGNAL(changed(const QColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorOperators, SIGNAL(changed(const QColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorQuotedStrings, SIGNAL(changed(const QColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorNumbers, SIGNAL(changed(const QColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorComments, SIGNAL(changed(const QColor&)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pColorDataTypes, SIGNAL(changed(const QColor&)), this, SIGNAL(sigDialogPageChanged()) );
        
        connect( m_pDialogPage->m_pFontChooser, SIGNAL(fontSelected( const QFont &)), this, SIGNAL(sigDialogPageChanged()) );
	}

	return m_pDialogPage;
}


void KPGSqlEditorSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_colorDefaultText = m_pDialogPage->m_pColorDefaultText->color();
		m_colorKeyWords = m_pDialogPage->m_pColorKeyWords->color();
		m_colorOperators = m_pDialogPage->m_pColorOperators->color();
		m_colorOperators = m_pDialogPage->m_pColorOperators->color();
		m_colorQuotedStrings = m_pDialogPage->m_pColorQuotedStrings->color();
		m_colorComments = m_pDialogPage->m_pColorComments->color();
		m_colorNumbers = m_pDialogPage->m_pColorNumbers->color();
        
        m_Font = m_pDialogPage->m_pFontChooser->font();
	}
}

void KPGSqlEditorSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pColorDefaultText->setColor( m_colorDefaultText );
		m_pDialogPage->m_pColorKeyWords->setColor( m_colorKeyWords );
		m_pDialogPage->m_pColorDataTypes->setColor( m_colorDataTypes );
		m_pDialogPage->m_pColorOperators->setColor( m_colorOperators );
		m_pDialogPage->m_pColorQuotedStrings->setColor( m_colorQuotedStrings );
		m_pDialogPage->m_pColorComments->setColor( m_colorComments );
		m_pDialogPage->m_pColorNumbers->setColor( m_colorNumbers );
        
        m_pDialogPage->m_pFontChooser->setFont(m_Font);
	}
}
