/***************************************************************************
                          kpgsqleditorsettings.h  -  description
                             -------------------
    begin                : Ne led 18 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGSQLEDITORSETTINGS_H
#define KPGSQLEDITORSETTINGS_H

#include "../kpgsettings.h"

#include <qcolor.h>
#include <qfont.h>

class KPGSqlEditorSettingsPage;

/**This class represents the group of configuration settings for the SQL query editor
  *
  *@author Lumir Vanek
  */

class KPGSqlEditorSettings : public KPGSettings
{
public:

	KPGSqlEditorSettings( QObject * pParent = 0, const char * pszName = 0 );

	// The following functions can be used to access this object's settings.
	const QColor & colorDefaultText() const { return m_colorDefaultText; }
	const QColor & colorKeyWords() const { return  m_colorKeyWords; }
	const QColor & colorDataTypes() const { return  m_colorDataTypes; }
	const QColor & colorOperators() const { return  m_colorOperators; }
	const QColor & colorQuotedStrings() const { return  m_colorQuotedStrings; }
	const QColor & colorComments() const { return  m_colorComments; }
	const QColor & colorNumbers() const { return  m_colorNumbers; }

    const QFont & font() const { return  m_Font; }
        
	/**
	 * Derived from @ref KPGSettings
	 */
	virtual QString dialogPageName() const;
		
    /**
	 * Derived from @ref KPGSettings
	 */
	virtual QString dialogPageHeader() const;
		
    /**
	 * Derived from @ref KPGSettings
	 */
	virtual QString dialogPageIcon() const;
	
    /**
	 * Derived from @ref KPGSettings
	 */
	virtual QWidget * dialogPage( QFrame * pParent );

protected:

	/**
	 * Derived from @ref KPGSettings
	 */
	
    virtual void write( KConfig * ) const;
	/**
	 * Derived from @ref KPGSettings
	 */
		
    virtual void read( const KConfig * );
	/**
	 * Derived from @ref KPGSettings
	 */
	virtual void setFromPage();
		
    /**
	 * Derived from @ref KPGSettings
	 */
	virtual void updatePage() const;

	// the settings itself
    QColor m_colorDefaultText;
    QColor m_colorKeyWords;
    QColor m_colorDataTypes;
    QColor m_colorOperators;
    QColor m_colorQuotedStrings;
    QColor m_colorNumbers;
    QColor m_colorComments;

    QFont m_Font;

	/**
	 * the corresponding configuration dialog page
	 * It is created on demand by @ref dialogPage.
	 */
	KPGSqlEditorSettingsPage * m_pDialogPage;
};

#endif
