/***************************************************************************
                          kpgsyntaxhighlighter.h  -  description
                             -------------------
    begin                : � led 13 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGSYNTAXHIGHLIGHTER_H
#define KPGSYNTAXHIGHLIGHTER_H

#include <qsyntaxhighlighter.h>

/**
  * SQL Syntax highlighter
  * @author Lumir Vanek
  */
class KPGSyntaxHighlighter : public QSyntaxHighlighter
{
public: 
	KPGSyntaxHighlighter(QTextEdit *);
	~KPGSyntaxHighlighter();
	
	void enable() { m_bEnabled = true; }
	void disable() { m_bEnabled = false; }
	
	// Return QStringList with SQL keywords
	static const QStringList listOfKeyWords();

	int highlightParagraph(const QString &text, int endStateOfLastPara);
	
	void setColorDefaultText(const QColor color) { m_clrDefaultText = color; }
	void setColorKeyWords(const QColor color) { m_clrKeyWord = color; }
	void setColorDataTypes(const QColor color) { m_clrDataType = color; }
	void setColorOperators(const QColor color) { m_clrOperator = color; }
	void setColorQuotedStrings(const QColor color) { m_clrQuotedString = color; }
	void setColorNumbers(const QColor color) { m_clrNumber = color; }
	void setColorComments(const QColor color) { m_clrComment = color; }
	
	const QColor colorDefaultText() const { return m_clrDefaultText; }
	const QColor colorKeyWords() const { return m_clrKeyWord; }
	const QColor colorDataTypes() const { return m_clrDataType; }
	const QColor colorOperators() const { return m_clrOperator; }
	const QColor colorQuotedStrings() const { return m_clrQuotedString; }
	const QColor colorNumbers() const { return m_clrNumber; }
	const QColor colorComments() const { return m_clrComment; }
  
protected:

	QColor m_clrDefaultText;
	QColor m_clrKeyWord;
	QColor m_clrDataType;
	QColor m_clrOperator;
	QColor m_clrQuotedString;
	QColor m_clrNumber; 
	QColor m_clrComment;
	
	bool m_bEnabled;
};

#endif
