//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "konsoleviewwidget.h"

#include <qlayout.h>
#include <qframe.h>
#include <qdir.h>

#include <kparts/part.h>
#include <klibloader.h>
#include <kdebug.h>
#include <kparts/partmanager.h>

KonsoleViewWidget::KonsoleViewWidget(KParts::PartManager *pPartManager, QWidget *parent)
 : QWidget(parent, "konsole widget"), part(0)
{
    m_pPartManager = pPartManager; 
    vbox = new QVBoxLayout(this);
}

KonsoleViewWidget::~KonsoleViewWidget()
{
}

void KonsoleViewWidget::show()
{
  activate();
  QWidget::show();
}

void KonsoleViewWidget::activate()
{
    if (part)
        return;

    KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");
    if (!factory)
        return;

    part = (KParts::ReadOnlyPart *) factory->create(this);
    if (!part)
        return;

    part->widget()->setFocusPolicy(QWidget::WheelFocus);
    setFocusProxy(part->widget());
    part->widget()->setFocus();
    
    if (part->widget()->inherits("QFrame"))
        ((QFrame*)part->widget())->setFrameStyle(QFrame::Panel|QFrame::Sunken);

    vbox->addWidget(part->widget());

    this->activePartChanged( m_pPartManager->activePart() );
    part->widget()->show();

    connect(part, SIGNAL(destroyed()), this, SLOT(partDestroyed()));
}


void KonsoleViewWidget::activePartChanged(KParts::Part *activatedPart)
{
    kdDebug() << "KonsoleViewWidget::activePartChanged()" << endl;
    KParts::ReadOnlyPart *ro_part = dynamic_cast<KParts::ReadOnlyPart*>(activatedPart);

    if (ro_part && !ro_part->url().isLocalFile())
    {
        kdDebug() << " ===> Hmmm ... part is null or not local ... :-/" << endl;
        return;
    }
    /*!!!QString dir;
    if (ro_part)
        dir = ro_part->url().directory();
    else if (owner->project())
        dir = owner->project()->projectDirectory();

    kdDebug() << " ===> Changing dir to " << dir << endl;
    if (dir.isEmpty())
        return;
    setDirectory( KURL(dir) );*/
}

void KonsoleViewWidget::setDirectory(const KURL &dirUrl)
{
    kdDebug() << "KonsoleViewWidget::setDirectory()" << endl;
    kdDebug() << " ===> part is " << (long)part << endl;

    if (part && dirUrl != part->url())
    {
        kdDebug() << " ===> Changing dirUrl.path() == " << dirUrl.path() << endl;
        kdDebug() << " ===> Changing part->url.path() == " << part->url().path() << endl;

        part->openURL( dirUrl );
    }
}

void KonsoleViewWidget::partDestroyed()
{
  part = 0;
  activate();
}

#include "konsoleviewwidget.moc"
