//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPG5STEPSWIZARD_H
#define KPG5STEPSWIZARD_H

#include "kpg5stepswizardbase.h"

class KPGSyntaxHighlighter;
class KPGConnection;

/**
  * Wizard with 5 steps
  *
  * @author Lumir Vanek
  */
class KPG5StepsWizard : public KPG5StepsWizardBase
{
Q_OBJECT
public:
    KPG5StepsWizard(QWidget *parent = 0, const char *name = 0);
    ~KPG5StepsWizard();

    // Set connection to database
	void setConnection(KPGConnection *);

	// Return connection
    KPGConnection * connection() const { return m_pConnection; }
    
    QWidget * pageWidget1() { return m_pPageWidget1; }
    QWidget * pageWidget2() { return m_pPageWidget2; }
    QWidget * pageWidget3() { return m_pPageWidget3; }
      
protected:
    // Run SQL query - as final Wizard operation
    void runQuery(bool = true);  
    
protected:
    QWidget *m_pPageWidget1;
    QWidget *m_pPageWidget2;
    QWidget *m_pPageWidget3;
    
private:  
    KPGConnection *m_pConnection;
    
    /** Syntax highlighter for m_pTextEditSQL */
    KPGSyntaxHighlighter *m_pSyntaxHighlighter;
        
protected slots:
    // Enable/disable next button for 1st page
    void slotEnableNextButton1(bool);

    // Enable/disable next button for 2nd page
    void slotEnableNextButton2(bool);
    
    // Enable/disable next button for 3rd page
    void slotEnableNextButton3(bool);
};

#endif
