//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatedomainwidget3.h"

// include files for Qt
#include <qlistview.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"


KPGCreateDomainWidget3::KPGCreateDomainWidget3(QWidget *parent, const char *name)
 : KPGCreateDomainWidget3Base(parent, name)
{
}

KPGCreateDomainWidget3::~KPGCreateDomainWidget3()
{
}

void KPGCreateDomainWidget3::slotConstraintNameChanged(const QString& strName)
{
  m_pPushButtonConstraintAdd->setEnabled(! m_pLineEditCheckExpression->text().isEmpty() &&
   ! strName.isEmpty());
}

void KPGCreateDomainWidget3::slotCheckExpressionChanged(const QString &strText)
{
   m_pPushButtonConstraintAdd->setEnabled(! strText.isEmpty() &&
   ! m_pLineEditConstraintName->text().isEmpty());
}

void KPGCreateDomainWidget3::slotConstraintsSelectionChanged(QListViewItem* pItem)
{
  m_pPushButtonConstraintDel->setEnabled(pItem != 0);
}

void KPGCreateDomainWidget3::slotConstraintsCurrentChanged(QListViewItem* pItem)
{
  m_pPushButtonConstraintDel->setEnabled(pItem != 0);
}

void KPGCreateDomainWidget3::slotConstraintAdd()
{
  	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewConstraints->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		pItem = pItem->nextSibling();
	}
	
	QString strSQL("CONSTRAINT \"");
	strSQL.append(m_pLineEditConstraintName->text());
	strSQL.append("\" CHECK (");
	strSQL.append(m_pLineEditCheckExpression->text());  
	strSQL.append(")");
  
  
  // Create item for new column
  QListViewItem *pNewItem;
  if(pLastItem == 0) 
    pNewItem = new QListViewItem(m_pListViewConstraints, strSQL);
  else
    pNewItem = new QListViewItem(m_pListViewConstraints, pLastItem, strSQL);
  
  pNewItem->setPixmap(0, * KPGTreeItem::m_pIconCheckConstr);
  
  m_pLineEditCheckExpression->setText("VALUE ");  
  m_pLineEditConstraintName->setText("");
  sigEnableNextButton(true);
}

void KPGCreateDomainWidget3::slotConstraintDelete()
{
  QListViewItem *pSelectedItem = m_pListViewConstraints->selectedItem();
    if(pSelectedItem)
      delete pSelectedItem;
  
  m_pPushButtonConstraintDel->setEnabled(false);
  
  sigEnableNextButton(m_pListViewConstraints->childCount() > 0);
}

const QString KPGCreateDomainWidget3::getSQL() const
{
  QString strSQL;
  
  QListViewItem * pItem = m_pListViewConstraints->firstChild();
  while(pItem)
  {
    strSQL.append("\n");
    strSQL.append(pItem->text(0));
            
    pItem = pItem->nextSibling();
  }
  
  return strSQL;
}

#include "kpgcreatedomainwidget3.moc"
