//
// C++ Implementation: kpgcreaterulewidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreaterulewidget1.h"

// include files for Qt
#include <qradiobutton.h>
#include <qcheckbox.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 
#include <ktextedit.h> 

// application specific includes
#include "../kpogreview.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../kpgutil.h"


KPGCreateRuleWidget1::KPGCreateRuleWidget1(QWidget *parent, const char *name, const QString &strNamespace, const QString &strTableName)
 : KPGCreateRuleWidget1Base(parent, name)
{
	m_strNamespace = strNamespace;
	m_strTableName = strTableName;
	
	m_pLineEditRuleName->setFocus();
	
	m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditCommand);
	
	// Apply current configuration
	m_pTextEditCommand->setFont( KPoGreView::configuration()->sqleditor()->font() );
	
	m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
	m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
}

KPGCreateRuleWidget1::~KPGCreateRuleWidget1()
{
  delete m_pSyntaxHighlighter;
}

void KPGCreateRuleWidget1::slotRuleNameChanged(const QString& strText)
{
	emit sigEnableNextButton(! strText.isEmpty());
}

void KPGCreateRuleWidget1::slotDoAlsoToggled(bool bChecked)
{
	if(bChecked) m_pTextEditCommand->setEnabled(true);
}

void KPGCreateRuleWidget1::slotDoInsteadToggled(bool bChecked)
{
	if(bChecked) m_pTextEditCommand->setEnabled(true);
}

void KPGCreateRuleWidget1::slotDoNothingToggled(bool bChecked)
{
	if(bChecked) m_pTextEditCommand->setEnabled(false);
}

void KPGCreateRuleWidget1::slotEventActivated(const QString &strEvent)
{
  // SELECT rules must be unconditional INSTEAD rule
  if(strEvent == "SELECT")
  {
    m_pLineEditCondition->setEnabled(false);
    m_pRadioButtonDoInstead->setChecked(true);
    m_pRadioButtonDoAlso->setEnabled(false);
    m_pRadioButtonDoNothing->setEnabled(false);
  }
  else
  {
    m_pLineEditCondition->setEnabled(true);
    m_pRadioButtonDoAlso->setEnabled(true);
    m_pRadioButtonDoNothing->setEnabled(true);
  }
}

// Return SQL statement for CREATE RULE
const QString KPGCreateRuleWidget1::getSQL() const
{
  QString strSql("CREATE OR REPLACE RULE ");
  strSql.append(KPGUtil::quotedName(m_pLineEditRuleName->text()));
  strSql.append(" AS ON ");
  strSql.append(m_pComboBoxEvent->currentText());
  strSql.append("\nTO ");
  strSql.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName) + "\n");
  
  if(! m_pLineEditCondition->text().isEmpty())
  {
   strSql.append("WHERE ");
   strSql.append(m_pLineEditCondition->text());
   strSql.append("\n");
  }
  
  strSql.append("DO ");
  
  if(m_pRadioButtonDoAlso->isChecked())
  {
    strSql.append("ALSO ");
    strSql.append(m_pTextEditCommand->text());
  }
  
  if(m_pRadioButtonDoInstead->isChecked())
  {
    strSql.append("INSTEAD ");
    strSql.append(m_pTextEditCommand->text());
  }
  
  if(m_pRadioButtonDoNothing->isChecked())
  {
    strSql.append("NOTHING;");
  }
  
  if(! strSql.endsWith(";"))
    strSql.append(";");
    
  return strSql;
}


#include "kpgcreaterulewidget1.moc"
