//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateschemawidget2.h"

// include files for Qt
#include <qlabel.h>
#include <qcheckbox.h>
#include <qheader.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qstringlist.h> 

// include files for KDE
#include <klistbox.h>
#include <kdebug.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgitemsfolder.h"
#include "../kpgutil.h"


KPGCreateSchemaWidget2::KPGCreateSchemaWidget2(QWidget *parent, const char *name, bool bGrantOrRevoke)
 : KPGCreateSchemaWidget2Base(parent, name)
{
  m_bGrantOrRevoke = bGrantOrRevoke;
  
  if(bGrantOrRevoke)
  {
    strGR = "GRANT ";
    strTF = strTF + " TO ";
    m_pCheckBoxCascade->hide();
  }
  else
  {
    strGR = "REVOKE ";
    strTF = " FROM ";
    m_pCheckBoxGrantOptions->setText(i18n("Only revoke &GRANT privilege"));
  }
  
  m_pListViewGrants->setSortColumn(-1);  
}


KPGCreateSchemaWidget2::~KPGCreateSchemaWidget2()
{
}


/////////////////////////////////////////////////////////////////////
//                       GRANTS FUNCTIONS
///////////////////////////////////////////////////////////////////// 

void KPGCreateSchemaWidget2::slotCheckBoxAllToggled(bool bState)
{
  m_pCheckBoxCreate->setEnabled(!bState);
  m_pCheckBoxUsage->setEnabled(!bState);
  
  enableAddGrantButton();
}

void KPGCreateSchemaWidget2::slotCheckBoxCreateToggled(bool)
{
  enableAddGrantButton();
}

void KPGCreateSchemaWidget2::slotCheckBoxUsageToggled(bool)
{
  enableAddGrantButton();
}
  
void KPGCreateSchemaWidget2::slotCheckBoxPublicToggled(bool bState)
{
  m_pListBoxUsersGroups->setEnabled(!bState);
  m_pCheckBoxGrantOptions->setEnabled(!bState); // Grant options can only be granted to individual users, not to groups or PUBLIC.
  enableAddGrantButton();
}

void KPGCreateSchemaWidget2::slotGrantOptionsToggled(bool bState)
{
  m_pCheckBoxCascade->setEnabled(!m_bGrantOrRevoke && bState);
}

void KPGCreateSchemaWidget2::slotListBoxUsersSelectionChanged()
{
  enableAddGrantButton();
}

void KPGCreateSchemaWidget2::enableAddGrantButton()
{
  bool bAnyPrivilegeChecked = false;
  
  if(m_pCheckBoxAll->isChecked()) bAnyPrivilegeChecked = true;
    else
      if(m_pCheckBoxCreate->isChecked()) bAnyPrivilegeChecked = true;
        else
          if(m_pCheckBoxUsage->isChecked()) bAnyPrivilegeChecked = true;
  
  bool bAnyUserOrGroupChecked = false;        
  
  if(m_pCheckBoxPublic->isChecked()) 
    bAnyUserOrGroupChecked = true;
  else
    {
      if(m_pListBoxUsersGroups->count() > 0)
      {
        for(unsigned int i = 0; i <m_pListBoxUsersGroups->count(); i++)
        if(m_pListBoxUsersGroups->isSelected(i))
          {
            bAnyUserOrGroupChecked = true;
            break;
          }
      }
    }
  m_pPushButtonGrantAdd->setEnabled(bAnyPrivilegeChecked && bAnyUserOrGroupChecked);
}

/////////////////////////////////////////////////////////////////////
//                     COMMON FUNCTIONS
///////////////////////////////////////////////////////////////////// 

void KPGCreateSchemaWidget2::slotGrantAdd()
{
    QListViewItem *pLastItem = 0;
  
  QListViewItem * pItem = m_pListViewGrants->firstChild();
  while(pItem)
  {
    pLastItem = pItem;
    pItem = pItem->nextSibling();
  }
  
  QStringList strListOfSQLs; // string list for SQL clauses GRANT ...
  
  QString strWGO((m_bGrantOrRevoke && m_pCheckBoxGrantOptions->isChecked()) ? " WITH GRANT OPTION" : "");
  QString strGOF((!m_bGrantOrRevoke && m_pCheckBoxGrantOptions->isChecked()) ? "GRANT OPTION FOR " : "");
  QString strC((!m_bGrantOrRevoke && m_pCheckBoxCascade->isChecked()) ? " CASCADE" : "");
      
  if(m_pCheckBoxPublic->isChecked() && m_pCheckBoxAll->isChecked())
  {
    strListOfSQLs.append(strGR + "ALL ON SCHEMA " + KPGUtil::quotedName(m_strSchemaName) + strTF + "PUBLIC");   
  }
  
  if(m_pCheckBoxPublic->isChecked() && !m_pCheckBoxAll->isChecked())
  {
    QString strSQL(strGR);
    
    if(m_pCheckBoxCreate->isChecked())
      strSQL.append("CREATE, ");
          
    if(m_pCheckBoxUsage->isChecked())
      strSQL.append("USAGE");
      
    if(strSQL.right(2) == ", ")  
      strSQL = strSQL.left(strSQL.length() - 2);
      
    strSQL.append(" ON SCHEMA " + KPGUtil::quotedName(m_strSchemaName) + strTF + "PUBLIC");   
    
    strListOfSQLs.append(strSQL);
  }
  
  if(!m_pCheckBoxPublic->isChecked() && m_pCheckBoxAll->isChecked())
  {
    for(unsigned int i = 0; i < m_pListBoxUsersGroups->count(); i++)
    {
      if(m_pListBoxUsersGroups->isSelected(i))
      {
        QListBoxItem * pLbItem = m_pListBoxUsersGroups->item(i);
        
        if(pLbItem->rtti() != RTTI_KPGLISTBOXITEM)
        {
          kdError() << "KPGCreateSchemaWidget2::slotGrantAdd - bad object type !" << endl;
          return;
        }  
        
        KPGListBoxItem *pListBoxItem = static_cast <KPGListBoxItem *> (pLbItem);
        
        if(pListBoxItem->type() == KPGTreeItem::nodeGroup)
          strListOfSQLs.append(strGR + "ALL ON SCHEMA " + KPGUtil::quotedName(m_strSchemaName) + strTF + "GROUP " + pListBoxItem->text());
        else
          strListOfSQLs.append(strGR + strGOF + "ALL ON SCHEMA " + KPGUtil::quotedName(m_strSchemaName) + strTF + pListBoxItem->text() + strWGO + strC);    
      }
    }
  }
  
  if(!m_pCheckBoxPublic->isChecked() && !m_pCheckBoxAll->isChecked())
  {
    for(unsigned int i = 0; i < m_pListBoxUsersGroups->count(); i++)
    {
      if(m_pListBoxUsersGroups->isSelected(i))
      {
        QListBoxItem * pLbItem = m_pListBoxUsersGroups->item(i);
        
        if(pLbItem->rtti() != RTTI_KPGLISTBOXITEM)
        {
          kdError() << "KPGCreateSchemaWidget2::slotGrantAdd - bad object type !" << endl;
          return;
        }
        
        KPGListBoxItem *pListBoxItem = static_cast <KPGListBoxItem *> (pLbItem);        
                
        QString strSQL(strGR);
        
        if(pListBoxItem->type() != KPGTreeItem::nodeGroup)
           strSQL.append(strGOF);
            
        if(m_pCheckBoxCreate->isChecked())
          strSQL.append("CREATE, ");
                  
        if(m_pCheckBoxUsage->isChecked())
          strSQL.append("USAGE");
          
        if(strSQL.right(2) == ", ")  
          strSQL = strSQL.left(strSQL.length() - 2);
        
        if(pListBoxItem->type() == KPGTreeItem::nodeGroup)
          strSQL.append(" ON SCHEMA " + KPGUtil::quotedName(m_strSchemaName) + strTF + "GROUP " + pListBoxItem->text());
        else
          strSQL.append(" ON SCHEMA " + KPGUtil::quotedName(m_strSchemaName) + strTF + pListBoxItem->text() + strWGO + strC);
            
        strListOfSQLs.append(strSQL);
      }
    }
  }
      
  // Create items for new grants
  for ( QStringList::Iterator it = strListOfSQLs.begin(); it != strListOfSQLs.end(); ++it ) 
  {
    QString strSQL(*it);
    QListViewItem *pNewItem;
    
    if(pLastItem == 0) 
      pNewItem = new QListViewItem(m_pListViewGrants, strSQL);
    else
      pLastItem = pNewItem = new QListViewItem(m_pListViewGrants, pLastItem, strSQL); 
  }
  
  emit sigEnableNextButton(true);
}

void KPGCreateSchemaWidget2::slotGrantDelete()
{
  QListViewItem *pSelectedItem = m_pListViewGrants->selectedItem();
  if(pSelectedItem)
      delete pSelectedItem;
  
  if(m_pListViewGrants->childCount() == 0)
     emit sigEnableNextButton(false);
     
  m_pPushButtonGrantDel->setEnabled(false);
  
  enableAddGrantButton();
}

void KPGCreateSchemaWidget2::slotGrantsSelectionChanged(QListViewItem* pItem)
{
  m_pPushButtonGrantDel->setEnabled(pItem != 0);
}

void KPGCreateSchemaWidget2::slotGrantsCurrentChanged(QListViewItem* pItem)
{
  m_pPushButtonGrantDel->setEnabled(pItem != 0);
}

// Return part of SQL statement for GRANT
const QString KPGCreateSchemaWidget2::getSQL() const
{
  QString strSQL;
  
  QListViewItem * pItem = m_pListViewGrants->firstChild();
  while(pItem)
  {
    strSQL.append(pItem->text(0));
    strSQL.append(";\n");
            
    pItem = pItem->nextSibling();
  }
  
  return strSQL;
}

#include "kpgcreateschemawidget2.moc"
