//
// C++ Implementation: kpgcreatetablewidget4
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablewidget4.h"

// include files for Qt
#include <qlabel.h>
#include <qcheckbox.h>
#include <qheader.h>
#include <qlistview.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 
#include <ktextedit.h> 
#include <kactionselector.h> 

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgfunctionsfolder.h"
#include "../DbObjects/kpgfunction.h"
#include "../kpgutil.h"


KPGCreateTableWidget4::KPGCreateTableWidget4(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateTableWidget4Base(parent, name)
{
	m_pDatabase = pDatabase;
  	m_bWhereSaved = false;
	
	m_pListViewIndexes->setSortColumn(-1);
  
  // This is here, instead of making connection in Qt Designer due to bug - forward declaration
  // class QListBoxItem; is not added to h file.
  connect( m_pActionSelectorIDXColumns, SIGNAL( added(QListBoxItem*) ), this, SLOT( slotColumnAdded(QListBoxItem*) ) );
  connect( m_pActionSelectorIDXColumns, SIGNAL( removed(QListBoxItem*) ), this, SLOT( slotColumnRemoved(QListBoxItem*) ) );
}


KPGCreateTableWidget4::~KPGCreateTableWidget4()
{
}

void KPGCreateTableWidget4::setListOfAvailableColumns(KPGListTableColumnWizInfo &listOfAvailableColumns)
{
	m_listOfAvailableColumns = listOfAvailableColumns;
	
	m_pActionSelectorIDXColumns->availableListBox()->clear();
	m_pActionSelectorIDXColumns->selectedListBox()->clear();
	
	for(unsigned int i= 0; i < m_listOfAvailableColumns.count(); i++)
	{
		KPGTableColumnWizInfo *pTableColumnWizInfo = static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i));
		
		if(pTableColumnWizInfo->attNum() < 1) continue; // skip system columns
		
		m_pActionSelectorIDXColumns->availableListBox()->insertItem(
				pTableColumnWizInfo->icon(), 
				pTableColumnWizInfo->name()
				);
	}
}

void KPGCreateTableWidget4::slotCurrentFunctionChanged(int iIndex)
{
	if(iIndex > 0)
	{
		if(!m_bWhereSaved)
			{
			  m_strSavedWherePredicate = m_pTextEditWherePredicate->text(); 
				m_bWhereSaved = true;
			}
			
		m_pTextEditWherePredicate->setText("");
		m_pTextEditWherePredicate->setEnabled(false);	
	}
	else
	{
		m_pTextEditWherePredicate->setText(m_strSavedWherePredicate);
		m_pTextEditWherePredicate->setEnabled(true);
		m_bWhereSaved = false;	
	}
}

/////////////////////////////////////////////////////////////////////
//                 INDEX COLUMNS FUNCTIONS
/////////////////////////////////////////////////////////////////////	

void KPGCreateTableWidget4::slotColumnAdded(QListBoxItem *)
{
  setDefaultIndexName();
	enableAddIndexButton( m_pLineEditIndexName->text().isEmpty());
	refreshListOfFunctions(m_pActionSelectorIDXColumns->selectedListBox()->count());
}

void KPGCreateTableWidget4::slotColumnRemoved(QListBoxItem *)
{
  enableAddIndexButton(m_pLineEditIndexName->text().isEmpty());
	refreshListOfFunctions(m_pActionSelectorIDXColumns->selectedListBox()->count());
}

void KPGCreateTableWidget4::refreshListOfFunctions(int nArguments)
{
	m_pComboBoxFunctions->clear();
	if(nArguments == 0) return;

	m_pComboBoxFunctions->insertItem(""); // void item for index without function
	
	//--- Obtain list of "immutable" functions with required number of parameters
	
  // First find schema - this same as created table
  KPGTreeItem *pItem = m_pDatabase->getChildByName(m_strNamespaceName);
  if(!pItem)
  {
    kdDebug() << k_funcinfo << " No item found: " << m_strNamespaceName << endl;
    return;
  }
        
  KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
  KPGFunctionsFolder *pFunctionsFolder = pSchema->getFunctionsFolder();
  
	// traverse list of functions
  QListViewItem * pLvItem = pFunctionsFolder->firstChild();
  while(pLvItem)
  {
    KPGFunction *pFunction = static_cast <KPGFunction *> (pLvItem);
      
    if((pFunction->getVolatile() == "i") && (pFunction->nArgs() == nArguments))
      m_pComboBoxFunctions->insertItem(* pFunction->pixmap(0), pFunction->text(0)); 
      
    pLvItem = pLvItem->nextSibling();
  }
	
	//------------------------------------------------------------------
	
	// Second, find schema - pg_catalog
	pItem = m_pDatabase->getChildByName("pg_catalog");
    if(!pItem)
    {
        kdDebug() << k_funcinfo << " No item found: " << "pg_catalog" << endl;
        return;
    }
        
  pSchema = static_cast <KPGSchema *> (pItem);
  pFunctionsFolder = pSchema->getFunctionsFolder();
	
	// traverse list of functions
  pLvItem = pFunctionsFolder->firstChild();
  while(pLvItem)
  {
    KPGFunction *pFunction = static_cast <KPGFunction *> (pLvItem);
      
    if((pFunction->getVolatile() == "i") && (pFunction->nArgs() == nArguments))
      m_pComboBoxFunctions->insertItem(* pFunction->pixmap(0), pFunction->text(0)); 
      
    pLvItem = pLvItem->nextSibling();
  }
}

/////////////////////////////////////////////////////////////////////
//                     COMMON FUNCTIONS
/////////////////////////////////////////////////////////////////////	


void KPGCreateTableWidget4::setDefaultIndexName()
{
	QString strTableName(m_strTableName);
  	
  	QString strFKName("idx_" + strTableName + "__");
			
	for(unsigned int i = 0; i < m_pActionSelectorIDXColumns->selectedListBox()->count(); i++)
			strFKName.append("_" + m_pActionSelectorIDXColumns->selectedListBox()->text(i));
								
	m_pLineEditIndexName->setText(strFKName);
							
}

void KPGCreateTableWidget4::slotIndexNameChanged(const QString& strText)
{
	enableAddIndexButton(strText.isEmpty());
}

void KPGCreateTableWidget4::enableAddIndexButton(bool bIndexNameEmpty)
{
	if(bIndexNameEmpty)
		m_pPushButtonIndexAdd->setEnabled(false);
	else
		m_pPushButtonIndexAdd->setEnabled(m_pActionSelectorIDXColumns->selectedListBox()->count() > 0);
}

void KPGCreateTableWidget4::slotIndexAdd()
{
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewIndexes->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		pItem = pItem->nextSibling();
	}
	
	QString strSql("CREATE");
	
	if(m_pCheckBoxUnique->isChecked())
		strSql.append(" UNIQUE");
	
	strSql.append(" INDEX ");
		
	strSql.append(KPGUtil::quotedName(m_pLineEditIndexName->text()));
	strSql.append(" ON ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_strNamespaceName, m_strTableName));
	
	if(m_pComboBoxMethod->currentItem() > 0)
		strSql.append(" USING " + m_pComboBoxMethod->currentText()); // USING ...
	
	strSql.append(" (");
		
	if(m_pComboBoxFunctions->currentItem() > 0)
		strSql.append(" " + KPGUtil::quotedName(m_pComboBoxFunctions->currentText()) + "("); // (func_name(column1, column2, ... ))
		
	// List of index columns -----------------------------------------	
	for(unsigned int i = 0; i < m_pActionSelectorIDXColumns->selectedListBox()->count(); i++)
	{
		strSql.append(KPGUtil::quotedName(m_pActionSelectorIDXColumns->selectedListBox()->text(i)));
		
		if(i < m_pActionSelectorIDXColumns->selectedListBox()->count() - 1)
			strSql.append(", ");
	}
	strSql.append(")");
	//----------------------------------------------------------------
	
	if(m_pComboBoxFunctions->currentItem() > 0)
		strSql.append(")");
	
  if(m_pComboBoxTablespace->currentItem() > 0)
    strSql.append(" TABLESPACE " + KPGUtil::quotedName(m_pComboBoxTablespace->currentText()));  
    
	if(m_pTextEditWherePredicate->text().length() > 0)
	{
		strSql.append(" WHERE ");
		strSql.append("(" + m_pTextEditWherePredicate->text() + ")");
	}
		
	// Create item for new index
	QListViewItem *pNewItem;
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewIndexes, strSql);
	else
		pNewItem = new QListViewItem(m_pListViewIndexes, pLastItem, strSql);
	
	pNewItem->setPixmap(0, * KPGTreeItem::m_pIconIndex);
	
	// Renew available columns list, clear index columns list
	m_pActionSelectorIDXColumns->selectedListBox()->clear();
	m_pActionSelectorIDXColumns->availableListBox()->clear();
	
	for(unsigned int i= 0; i < m_listOfAvailableColumns.count(); i++)
		{
			m_pActionSelectorIDXColumns->availableListBox()->insertItem(
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->icon(), 
				static_cast <KPGTableColumnWizInfo *> (m_listOfAvailableColumns.at(i))->name()
				);
		}
		
	// Clean up dialog	
	m_pLineEditIndexName->setText("");
	m_pComboBoxFunctions->clear();
	m_pTextEditWherePredicate->setText("");
	m_pTextEditWherePredicate->setEnabled(true);
	sigEnableNextButton(true);
}

void KPGCreateTableWidget4::slotIndexDelete()
{
	QListViewItem *pSelectedItem = m_pListViewIndexes->selectedItem();
	if(pSelectedItem)
			delete pSelectedItem;
	
	m_pPushButtonIndexDel->setEnabled(false);
	
	enableAddIndexButton(m_pLineEditIndexName->text().isEmpty());
	sigEnableNextButton(m_pListViewIndexes->childCount() > 0);
}

void KPGCreateTableWidget4::slotIndexesSelectionChanged(QListViewItem* pItem)
{
	m_pPushButtonIndexDel->setEnabled(pItem != 0);
}

void KPGCreateTableWidget4::slotIndexesCurrentChanged(QListViewItem* pItem)
{
	m_pPushButtonIndexDel->setEnabled(pItem != 0);
}

// Return part of SQL statement for CREATE TABLE
const QString KPGCreateTableWidget4::getSQL() const
{
	QString strSql;
	
	QListViewItem * pItem = m_pListViewIndexes->firstChild();
	while(pItem)
	{
		strSql.append("\n");
		strSql.append(pItem->text(0));
		strSql.append(";");
					  
		pItem = pItem->nextSibling();
	}
	
	return strSql;
}


#include "kpgcreatetablewidget4.moc"
