//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetypewidget2.h"

// include files for KDE
#include <kdebug.h>
#include <kcombobox.h> 

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgfunctionsfolder.h"
#include "../DbObjects/kpgfunction.h"
#include "../kpgutil.h"


KPGCreateTypeWidget2::KPGCreateTypeWidget2(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateTypeWidget2Base(parent, name)
{
    m_pDatabase = pDatabase;
   
    // fill schemas to combobox
    KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxSchema);
}

KPGCreateTypeWidget2::~KPGCreateTypeWidget2()
{
}

void KPGCreateTypeWidget2::refreshListOfFunctions()
{
    QString strNamespace(m_pComboBoxSchema->currentText());
    
    // Find schema
    KPGTreeItem *pItem = m_pDatabase->getChildByName(strNamespace);
    if(!pItem)
    {
        kdDebug() << "KPGCreateTypeWidget2::refreshListOfFunctions: no item found: " << strNamespace << endl;
        return;
    }
    
    KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
    
    // Construct schema qualified datatype name
    QString strNamespace_DataType;
    if(strNamespace == "public")
        strNamespace_DataType = m_strDataType;
    else
        strNamespace_DataType = "\"" + strNamespace + "\"." + m_strDataType;
        
    // clear comboboxes
    m_pComboBoxInputFunction->clear();
    m_pComboBoxOutputFunction->clear();
    m_pComboBoxSendFunction->clear();
    m_pComboBoxReceiveFunction->clear();
    m_pComboBoxAnalyzeFunction->clear();
    
    m_pComboBoxSendFunction->insertItem("");
    m_pComboBoxReceiveFunction->insertItem("");
    m_pComboBoxAnalyzeFunction->insertItem("");
    
    //--- Obtain list of functions
    KPGFunctionsFolder *pFunctionsFolder = pSchema->getFunctionsFolder();
    
    // Fill list of functions
    QListViewItem * pLvItem = pFunctionsFolder->firstChild();
    while(pLvItem)
    {
        KPGFunction *pFunction = static_cast <KPGFunction *> (pLvItem);
        
        QString strFunction;
        if(strNamespace == "public")
        strFunction = pFunction->text(0);
        else
        strFunction = strNamespace + "." + pFunction->text(0);
        
        
        // INPUT
        if(((pFunction->nArgs() == 1) && (pFunction->argTypes() == "cstring")) || 
        ((pFunction->nArgs() == 3) && (pFunction->argTypes() == "cstring, oid, integer")))
        m_pComboBoxInputFunction->insertItem(* pFunction->pixmap(0), strFunction + "(" + pFunction->argTypes() + ")");
        
        // OUTPUT
        if(((pFunction->nArgs() == 1) && (pFunction->argTypes() == strNamespace_DataType)) || 
        ((pFunction->nArgs() == 2) && (pFunction->argTypes() == strNamespace_DataType + ", oid")))
        m_pComboBoxOutputFunction->insertItem(* pFunction->pixmap(0), strFunction + "(" + pFunction->argTypes() + ")"); 
        
        // SEND
        if(((pFunction->nArgs() == 1) && (pFunction->argTypes() == strNamespace_DataType)) || 
        ((pFunction->nArgs() == 2) && (pFunction->argTypes() == strNamespace_DataType + ", oid")))
        {
            if(pFunction->returnTypName() == "bytea")
                m_pComboBoxSendFunction->insertItem(* pFunction->pixmap(0), strFunction + "(" + pFunction->argTypes() + ")"); 
        }
        
        // RECEIVE
        if(((pFunction->nArgs() == 1) && (pFunction->argTypes() == "internal")) || 
        ((pFunction->nArgs() == 2) && (pFunction->argTypes() == strNamespace_DataType + "internal, oid")))
        {
            if(pFunction->returnTypName() == m_strDataType)
                m_pComboBoxReceiveFunction->insertItem(* pFunction->pixmap(0), strFunction + "(" + pFunction->argTypes() + ")"); 
        }
        
        // ANALYZE
        if((pFunction->nArgs() == 1) && (pFunction->argTypes() == "internal") && (pFunction->returnTypName() == "boolean"))
        m_pComboBoxAnalyzeFunction->insertItem(* pFunction->pixmap(0), strFunction + "(" + pFunction->argTypes() + ")"); 
        
        pLvItem = pLvItem->nextSibling();
    }
    
    emit sigEnableNextButton(!m_pComboBoxInputFunction->currentText().isEmpty() && !m_pComboBoxOutputFunction->currentText().isEmpty()); 
}

void KPGCreateTypeWidget2::slotSchemaActivated(int)
{
  refreshListOfFunctions();
}

void KPGCreateTypeWidget2::slotInputFunctionChanged(const QString& strInputFunction)
{
  emit sigEnableNextButton(!strInputFunction.isEmpty() && !m_pComboBoxOutputFunction->currentText().isEmpty()); 
}
    
void KPGCreateTypeWidget2::slotOutputFunctionChanged(const QString &strOutputFunction)
{
  emit sigEnableNextButton(!strOutputFunction.isEmpty() && !m_pComboBoxInputFunction->currentText().isEmpty()); 
}

// Return part of SQL statement for CREATE TYPE
const QString KPGCreateTypeWidget2::getSQL() const
{
  QString strSQL(" (");
  
  QString strNamespaceFunction; // "namespace"."function"
  
  strSQL.append("\nINPUT = ");
  strNamespaceFunction = "\"" +  m_pComboBoxInputFunction->currentText().left(m_pComboBoxInputFunction->currentText().find('(')) +  "\"";
  strNamespaceFunction.replace('.', "\".\"");
  strSQL.append(strNamespaceFunction);
  
  strSQL.append("\n, OUTPUT = ");
  strNamespaceFunction = "\"" +  m_pComboBoxOutputFunction->currentText().left(m_pComboBoxOutputFunction->currentText().find('(')) + "\"";
  strNamespaceFunction.replace('.', "\".\"");
  strSQL.append(strNamespaceFunction);
  
  if(!m_pComboBoxReceiveFunction->currentText().isEmpty())
  {
    strSQL.append("\n, RECEIVE = ");
    strNamespaceFunction = "\"" +  m_pComboBoxReceiveFunction->currentText().left(m_pComboBoxReceiveFunction->currentText().find('(')) +  "\"";
    strNamespaceFunction.replace('.', "\".\"");
    strSQL.append(strNamespaceFunction);
  }
  
  if(!m_pComboBoxSendFunction->currentText().isEmpty())
  {
    strSQL.append("\n, SEND = ");
    strNamespaceFunction = "\"" +  m_pComboBoxSendFunction->currentText().left(m_pComboBoxSendFunction->currentText().find('(')) +  "\"";
    strNamespaceFunction.replace('.', "\".\"");
    strSQL.append(strNamespaceFunction);
  }
    
  if(!m_pComboBoxAnalyzeFunction->currentText().isEmpty())
  {
    strSQL.append("\n, ANALYZE = ");
    strNamespaceFunction = "\"" +  m_pComboBoxAnalyzeFunction->currentText().left(m_pComboBoxAnalyzeFunction->currentText().find('(')) +  "\"";
    strNamespaceFunction.replace('.', "\".\"");
    strSQL.append(strNamespaceFunction);
  }
  
  return strSQL;
}

#include "kpgcreatetypewidget2.moc"
