//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifycolumntypewidget1.h"

// include files for Qt
#include <qlabel.h>
#include <qspinbox.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kcombobox.h> 

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgdomainsfolder.h"


KPGModifyColumnTypeWidget1::KPGModifyColumnTypeWidget1(QWidget *parent, const char *name, KPGDomainsFolder *pDomainsFolder)
 : KPGModifyColumnTypeWidget1Base(parent, name)
{
  fillBasicDatatypes();
  fillDomains(pDomainsFolder);
  
  m_pComboBoxDataType->setCurrentItem(0);
  slotComboDataTypeActivated(m_pComboBoxDataType->currentText());
}

void KPGModifyColumnTypeWidget1::fillBasicDatatypes()
{
  m_pComboBoxDataType->clear();
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "char(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "varchar(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnChar, "text");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnXml, "xml");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "smallint");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "integer");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigint");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "decimal(p, s)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "numeric(p, s)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "real");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "double precision");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "money");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "serial");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigserial");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnUuid, "uuid");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit(n)");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit varying(n)");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBool, "bool");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)]");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)] with time zone");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "date");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)]");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)] with time zone");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnDate, "interval [(p)]");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnBin, "bytea");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "point");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "line");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "lseg");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "polygon");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "box");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "path");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "circle");
  
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "inet");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "cidr");
  m_pComboBoxDataType->insertItem(* KPGTreeItem::m_pIconColumnNet, "macaddr");
}

void KPGModifyColumnTypeWidget1::fillDomains(KPGDomainsFolder *pDomainsFolder)
{
  pDomainsFolder->fillComboBoxWithChildItems(m_pComboBoxDataType);
  
  m_pComboBoxDataType->setCurrentItem(0);
  slotComboDataTypeActivated(m_pComboBoxDataType->currentText());
}

KPGModifyColumnTypeWidget1::~KPGModifyColumnTypeWidget1()
{
}

// Display comment for selected data type
void KPGModifyColumnTypeWidget1::slotComboDataTypeActivated(const QString& strText)
{
  // Enable/disable precision and scale spins
  m_pSpinBoxPrecision->setEnabled(false);
  m_pSpinBoxScale->setEnabled(false);
  
  if(strText.find("(n)") > 0)
  {
    m_pSpinBoxPrecision->setEnabled(true);
  }
  
  if(strText.find("(p, s)") > 0)
  {
    m_pSpinBoxPrecision->setEnabled(true);
    m_pSpinBoxScale->setEnabled(true);
  }
  
  if(strText.find("[(p)]") > 0)
  {
    m_pSpinBoxPrecision->setEnabled(true);
  }

  // Set help text for selected data type
  if(strText == "char(n)")
  { 
    m_pTextLabelComment->setText("fixed-length, blank padded character string");
    
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 10 );
    
    return;
  }    

  if(strText == "varchar(n)")
  { 
    m_pTextLabelComment->setText("variable-length character string");
    
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 10 );
    
    return;
  }    

  if(strText == "text")
  { 
    m_pTextLabelComment->setText("variable-length character string, unlimited length");
    return;
  }    


  if(strText == "smallint")
  { 
    m_pTextLabelComment->setText("2 bytes, small range fixed-precision, -32768 to +32767");
    return;
  }    

  if(strText == "integer")
  { 
    m_pTextLabelComment->setText("4 bytes, usual choice for fixed-precision, -2147483648 to +2147483647");
    return;
  }    

  if(strText == "bigint")
  { 
    m_pTextLabelComment->setText("8 bytes, large range fixed-precision, -9223372036854775808 to 9223372036854775807");
    return;
  }    

  if((strText == "decimal(p, s)") || (strText == "numeric(p, s)"))
  { 
    m_pTextLabelComment->setText("variable, user-specified precision, exact, no limit");
    
    m_pSpinBoxPrecision->setMinValue( 1 );
    m_pSpinBoxPrecision->setMaxValue( 999 );
    
    m_pSpinBoxScale->setMinValue( 0 );
    m_pSpinBoxScale->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 10 );
    return;
  }    

  if(strText == "real")
  { 
    m_pTextLabelComment->setText("4 bytes, variable-precision, inexact, 6 decimal digits precision");
    return;
  }    

  if(strText == "double precision")
  { 
    m_pTextLabelComment->setText("8 bytes, variable-precision, inexact, 15 decimal digits precision");
    return;
  }    

  if(strText == "money")
  { 
    m_pTextLabelComment->setText("currency amount. This datatype will be deprecated. Use a numeric datatype instead");
    return;
  }  
  
  if(strText == "serial")
  { 
    m_pTextLabelComment->setText("4 bytes, autoincrementing integer, 1 to 2147483647");
    return;
  }    

  if(strText == "bigserial")
  { 
    m_pTextLabelComment->setText("8 bytes, large autoincrementing integer, 1 to 9223372036854775807");
    return;
  }    
  
  if(strText == "bit(n)")
  { 
    m_pTextLabelComment->setText("fixed-length bit string");  
    return;
  }
  
  if((strText == "bit(n)") || (strText == "bit varying(n)"))
  { 
    m_pTextLabelComment->setText("variable-length bit string");
    
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 999 );
    
    m_pSpinBoxPrecision->setValue( 255 );
    
    return;
  }
    
  if(strText == "bool")
  { 
    m_pTextLabelComment->setText("logical Boolean (true/false)");
    return;
  }
  
  if(strText == "date")
  { 
    m_pTextLabelComment->setText("date, 4 bytes, 4713 BC - AD 32767");
    return;
  }
    
  if(strText == "time [(p)]")
  { 
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 13 );
    
    m_pSpinBoxPrecision->setValue( 13 );
    
    m_pTextLabelComment->setText("time of day, 8 bytes, 00:00:00.00 - 23:59:59.99");
    return;
  }
  
  if(strText == "time [(p)] with time zone")
  { 
    m_pTextLabelComment->setText("time of day including time zone, 12 bytes, 00:00:00.00+12 - 23:59:59.99-12");
    
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 13 );
    
    m_pSpinBoxPrecision->setValue( 13 );
    return;
  }
  
  if(strText == "timestamp [(p)]")
  { 
    m_pTextLabelComment->setText("date and time, 8 bytes, 4713 BC - AD 1465001");
    
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 6 );
    
    m_pSpinBoxPrecision->setValue( 6 );

    return;
  }
  
  if(strText == "timestamp [(p)] with time zone")
  { 
    m_pTextLabelComment->setText("date and time, including time zone, 8 bytes, 4713 BC - AD 1465001");
    
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 6 );
    
    m_pSpinBoxPrecision->setValue( 6 );
    return;
  }
  
  if(strText == "interval [(p)]")
  { 
    m_pTextLabelComment->setText("time span, 12 bytes, from -178000000 years to 178000000 years");
    
    m_pSpinBoxPrecision->setMinValue( 0 );
    m_pSpinBoxPrecision->setMaxValue( 6 );
    
    m_pSpinBoxPrecision->setValue( 6 );
    
    return;
  }
  
  if(strText == "bytea")
  { 
    m_pTextLabelComment->setText("variable-length binary data, 4 bytes plus the data");
    return;
  }
    
  if(strText == "point")
  { 
    m_pTextLabelComment->setText("geometric point in 2D plane");
    return;
  }
  
  if(strText == "line")
  { 
    m_pTextLabelComment->setText("infinite line in 2D plane");
    return;
  }
  
  if(strText == "lseq")
  { 
    m_pTextLabelComment->setText("line segment in 2D plane");
    return;
  }
  
  if(strText == "polygon")
  { 
    m_pTextLabelComment->setText("closed geometric path in 2D plane");
    return;
  }
  
  if(strText == "box")
  { 
    m_pTextLabelComment->setText("rectangular box in 2D plane");
    return;
  }
  
  if(strText == "path")
  { 
    m_pTextLabelComment->setText("open and closed geometric path in 2D plane");
    return;
  }
  
  if(strText == "circle")
  { 
    m_pTextLabelComment->setText("circle (center and radius) in 2D plane");
    return;
  }
  
  if(strText == "inet")
  { 
    m_pTextLabelComment->setText("IP host address, 12 bytes");
    return;
  }
  
  if(strText == "cidr")
  { 
    m_pTextLabelComment->setText("IP network address, 12 bytes");
    return;
  }
  
  if(strText == "macaddr")
  { 
    m_pTextLabelComment->setText("MAC address (Ethernet card hardware address), 6 bytes");
    return;
  }
  
  m_pTextLabelComment->setText("");
}

// Return part of SQL stetement for ALTER TABLE ALTER COLUMN
const QString KPGModifyColumnTypeWidget1::getSQL() const
{
  QString strSQL("TYPE ");
  
  QString strDefinition(m_pComboBoxDataType->currentText());
  
  //----------------------------------------------------------- 
  int i;
  if((i = strDefinition.find("(n)")) > 0)
  {
    strDefinition = strDefinition.left(strDefinition.length() - 3); // strip (n)
        
    strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
  }
  
  if((i = strDefinition.find("(p, s)")) > 0)
  {
    strDefinition = strDefinition.left(strDefinition.length() - 6); // strip (p, s)
    
    strDefinition.append(QString("(%1, %2)").arg(m_pSpinBoxPrecision->value()).arg(m_pSpinBoxScale->value()));
  }
  
  if((i = strDefinition.find("[(p)]")) > 0)
  {
    QString strDefinitionPostfix(strDefinition.mid(i + 5, strDefinition.length() - i - 5));
    strDefinition = strDefinition.left(i); // strip (n)
    
    strDefinition.append(QString("(%1)").arg(m_pSpinBoxPrecision->value()));
    strDefinition.append(strDefinitionPostfix);
  }
    
  strSQL.append(strDefinition);
  //----------------------------------------------------------- 
  
  if(!m_pLineEditExpression->text().isEmpty())
  {
    strSQL.append("\nUSING ");
    strSQL.append(m_pLineEditExpression->text());
  }
  
  return strSQL;
}

#include "kpgmodifycolumntypewidget1.moc"
