//
// C++ Interface: kpgmodifyviewwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGMODIFYVIEWWIDGET1_H
#define KPGMODIFYVIEWWIDGET1_H

#include "kpgmodifyviewwidget1base.h"

// include files for libpgxx 
#include <pqxx/util> 
#include <pqxx/transaction> 

class KPGDatabase;
class KPGSyntaxHighlighter;

/**
Widget for Modify view Wizard

@author Lumir Vanek
*/

class KPGModifyViewWidget1 : public KPGModifyViewWidget1Base
{
Q_OBJECT
public:
    KPGModifyViewWidget1(QWidget *parent, const char *name, KPGDatabase *);
    ~KPGModifyViewWidget1();

		const QString getSQL() const;
		
protected:
		void displayResult(pqxx::result, const QString&);

protected slots:
		virtual void slotTestSQL();
		virtual void slotTextEditSQLChanged();
		
protected:
		KPGDatabase *m_pDatabase;
		
		/** Syntax highlighter for m_pTextEditSQL */
  	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
				
signals:
		void sigEnableNextButton(bool);		
};

#endif
