//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgprivilegeswizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <klocale.h>

#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "kpgcreatetablewidget5.h"
#include "kpgcreatedatabasewidget2.h"
#include "kpgcreatetablespacewidget2.h"
#include "kpgcreatefunctionwidget5.h"
#include "kpgcreatelanguagewidget2.h"
#include "kpgcreateschemawidget2.h"


KPGPrivilegesWizard::KPGPrivilegesWizard(QWidget *parent, const char *name, eObjectType objType, bool bGrantOrRevoke, KPGServer *pServer, const QString &strNamespace, const QString
&strObjectName, const QString &strObjectParameters)
 : KPG3StepsWizard(parent, name)
{
  m_bGrantOrRevoke = bGrantOrRevoke;
  m_objType = objType;
  
  switch(objType)
  {
    case typeTable:       // table, view and sequence uses common wizard
    case typeView:
    case typeSequence:
        {
          KPGCreateTableWidget5 *pCreateTableWidget5 = new KPGCreateTableWidget5(WizardPage1, "KPGCreateTableWidget5", bGrantOrRevoke);
          m_pPageWidget1 = pCreateTableWidget5;
          WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
          connect(pCreateTableWidget5, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
              
          pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateTableWidget5->m_pListBoxUsersGroups);
          pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateTableWidget5->m_pListBoxUsersGroups);
            
          // Set table name and namespace
          pCreateTableWidget5->setTableName(strObjectName);
          pCreateTableWidget5->setNamespace(strNamespace);
        }    
        break;
     
     case typeDatabase:
        { 
          KPGCreateDatabaseWidget2 *pCreateDatabaseWidget2 = new KPGCreateDatabaseWidget2(WizardPage1, "KPGCreateDatabaseWidget2", bGrantOrRevoke);
          m_pPageWidget1 = pCreateDatabaseWidget2;
          WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
          connect(pCreateDatabaseWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
          
          pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateDatabaseWidget2->m_pListBoxUsersGroups);
          pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateDatabaseWidget2->m_pListBoxUsersGroups);
          
          // Set database name
          pCreateDatabaseWidget2->setDatabaseName(strObjectName);
        }    
        break;
     
     case typeTablespace:
        { 
          KPGCreateTablespaceWidget2 *pCreateTablespaceWidget2 = new KPGCreateTablespaceWidget2(WizardPage1, "KPGCreateTablespaceWidget2", bGrantOrRevoke);
          m_pPageWidget1 = pCreateTablespaceWidget2;
          WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
          connect(pCreateTablespaceWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
          
          pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateTablespaceWidget2->m_pListBoxUsersGroups);
          pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateTablespaceWidget2->m_pListBoxUsersGroups);
  
          // Set tablespace name
          pCreateTablespaceWidget2->setTablespaceName(strObjectName);
        }    
        break;
     
     case typeFunction:
        { 
          KPGCreateFunctionWidget5 *pCreateFunctionWidget5 = new KPGCreateFunctionWidget5(WizardPage1, "KPGCreateFunctionWidget5", bGrantOrRevoke);
          m_pPageWidget1 = pCreateFunctionWidget5;
          WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
          connect(pCreateFunctionWidget5, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
          
          pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateFunctionWidget5->m_pListBoxUsersGroups);
          pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateFunctionWidget5->m_pListBoxUsersGroups);
  
          // Set function name and schema
          pCreateFunctionWidget5->setFunctionName(strObjectName, strObjectParameters); pCreateFunctionWidget5->setNamespace(strNamespace);
        }    
        break;
     
     case typeLanguage:
        { 
          KPGCreateLanguageWidget2 *pCreateLanguageWidget2 = new KPGCreateLanguageWidget2(WizardPage1, "KPGCreateLanguageWidget2", bGrantOrRevoke);
          m_pPageWidget1 = pCreateLanguageWidget2;
          WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
          connect(pCreateLanguageWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
          
          pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateLanguageWidget2->m_pListBoxUsersGroups);
          pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateLanguageWidget2->m_pListBoxUsersGroups);
  
          // Set language name
          pCreateLanguageWidget2->setLanguageName(strObjectName);
        }    
        break;
     
     case typeSchema:
        { 
          KPGCreateSchemaWidget2 *pCreateSchemaWidget2 = new KPGCreateSchemaWidget2(WizardPage1, "KPGCreateSchemaWidget2", bGrantOrRevoke);
          m_pPageWidget1 = pCreateSchemaWidget2;
          WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
          connect(pCreateSchemaWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
          
          pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateSchemaWidget2->m_pListBoxUsersGroups);
          pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateSchemaWidget2->m_pListBoxUsersGroups);
  
          // Set schema name
          pCreateSchemaWidget2->setSchemaName(strObjectName);
        } 
        break;    
  }
 
  setNextEnabled(WizardPage1, false);
  languageChange();
}


KPGPrivilegesWizard::~KPGPrivilegesWizard()
{
}

void KPGPrivilegesWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    if(m_bGrantOrRevoke)
      setCaption( i18n( "Grant privileges" ) );
    else
      setCaption( i18n( "Revoke privileges" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Define user rights" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGPrivilegesWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL;
    
    switch(m_objType)
    
    { // TODO add quoted naming to wizard pages !!!
      case typeTable:       // table, view and sequence uses common wizard
      case typeView:
      case typeSequence:
              strSQL.append((static_cast <KPGCreateTableWidget5 *> (m_pPageWidget1))->getSQL());
              break;
      
      case typeDatabase:
              strSQL.append((static_cast <KPGCreateDatabaseWidget2 *> (m_pPageWidget1))->getSQL());
              break;
      
      case typeTablespace:
              strSQL.append((static_cast <KPGCreateTablespaceWidget2 *> (m_pPageWidget1))->getSQL());
              break;
      
      case typeFunction:
              strSQL.append((static_cast <KPGCreateFunctionWidget5 *> (m_pPageWidget1))->getSQL());
              break;
      
      case typeLanguage:
              strSQL.append((static_cast <KPGCreateLanguageWidget2 *> (m_pPageWidget1))->getSQL());
              break;
      
      case typeSchema:
              strSQL.append((static_cast <KPGCreateSchemaWidget2 *> (m_pPageWidget1))->getSQL());
              break;    
    }
    
    m_pTextEditSQL->setText(strSQL);
    
    setNextEnabled(WizardPage2, strSQL.length() > 0);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }
  
  // call parent
  KPG3StepsWizard::showPage(pPage);
}

#include "kpgprivilegeswizard.moc"
