/***************************************************************************
                          kpgsetdescriptionwizard.h
                             -------------------
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/
 
#ifndef KPGSETDESCRIPTIONWIZARD_H
#define KPGSETDESCRIPTIONWIZARD_H

#include "kpg3stepswizard.h"

/**
Wizard for setting database object description

	@author Lumir Vanek
*/
class KPGSetDescriptionWizard : public KPG3StepsWizard
{
public:
    KPGSetDescriptionWizard(QWidget *, const QString &, const QString &, const QString &, const QString &, const QString & = QString::null, const QString & = QString::null);
    ~KPGSetDescriptionWizard();

	const QString newDescription() const; 

protected:
	virtual void showPage(QWidget *);
		
protected:
	
	QString m_strObjectType; // type of the dropped table - FUNCTION, RULE, TRIGGER ...
    QString m_strObjectName; // name of the dropped object
    QString m_strNamespace;  // name of the namespace
	QString m_strTable;		 // name of the table, than contain object (column, index, rule, trigger ...)
	QString m_strObjectParameters; // another parameters, e.g. function arguments
	
	// Old description
	QString m_strOldDesc;

protected slots:
	virtual void languageChange();	
};

#endif
