//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsetdomaindefaultwizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "kpgmodifycolumndefaultwidget1.h"
#include "../kpgutil.h"

KPGSetDomainDefaultWizard::KPGSetDomainDefaultWizard(QWidget *parent, const char *name, const QString& strNamespace, const QString& strDomain)
 : KPG3StepsWizard(parent, name)
{
  m_strNamespace = strNamespace; 
  m_strDomain = strDomain;
    
  // borrow widget that modify column default - it have this same functionality  
  KPGModifyColumnDefaultWidget1 *pModifyColumnWidget1 = new KPGModifyColumnDefaultWidget1(WizardPage1, "KPGModifyColumnDefaultWidget1");
  m_pPageWidget1 = pModifyColumnWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pModifyColumnWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  languageChange();
}

KPGSetDomainDefaultWizard::~KPGSetDomainDefaultWizard()
{
}

void KPGSetDomainDefaultWizard::setDefaultExpression(const QString &strText)
{
  KPGModifyColumnDefaultWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnDefaultWidget1 *> (m_pPageWidget1);
  pModifyColumnWidget1->m_pLineEditDefaultExpression->setText(strText);
}

void KPGSetDomainDefaultWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Modify domain" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Set domain default" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGSetDomainDefaultWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    // prepare SQL statement
    QString strSQL("ALTER DOMAIN ");
    strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strDomain));
    strSQL.append(" ");
        
    KPGModifyColumnDefaultWidget1 *pModifyColumnWidget1 = static_cast <KPGModifyColumnDefaultWidget1 *> (m_pPageWidget1);
    strSQL.append(pModifyColumnWidget1->getSQL());
    strSQL.append(";\n");
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG3StepsWizard::showPage(pPage);
}


#include "kpgsetdomaindefaultwizard.moc"
