//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGACLITEM_H
#define KPGACLITEM_H

#include <qvaluelist.h>

class QListViewItem;

/**
ACL item

@author Lumir Vanek
*/

class KPGAclItem
{
public:
    KPGAclItem() {};
    KPGAclItem(const QString &);
    ~KPGAclItem();

    const QString& grantor() const { return  m_strGrantor; } 
    const QString& grantee() const { return m_strGrantee; }
        
    // Those functions return User right attribute state loaded from DB server
    bool canSelect() const { return m_bSELECT; }
    bool canUpdate() const { return m_bUPDATE; }
    bool canInsert() const { return m_bINSERT; }
    bool canDelete() const { return m_bDELETE; }
    bool canCreateRule() const { return m_bRULE; }
    bool canCreateReference() const { return m_bREFERENCES; }
    bool canCreateTrigger() const { return m_bTRIGGER; }
    bool canExecute() const { return m_bEXECUTE; }
    bool canUse() const { return m_bUSAGE; }
    bool canCreate() const { return m_bCREATE; }
    bool canCreateTemp() const { return m_bTEMPORARY; }
    
    bool canGrantSelect() const { return m_bGrantSELECT; }
    bool canGrantUpdate() const { return m_bGrantUPDATE; }
    bool canGrantInsert() const { return m_bGrantINSERT; }
    bool canGrantDelete() const { return m_bGrantDELETE; }
    bool canGrantCreateRule() const { return m_bGrantRULE; }
    bool canGrantCreateReference() const { return m_bGrantREFERENCES; }
    bool canGrantCreateTrigger() const { return m_bGrantTRIGGER; }
    bool canGrantExecute() const { return m_bGrantEXECUTE; }
    bool canGrantUse() const { return m_bGrantUSAGE; }
    bool canGrantCreate() const { return m_bGrantCREATE; }
    bool canGrantCreateTemp() const { return m_bGrantTEMPORARY; }
    
    // Set m_pListViewItem
    void setListViewItem(QListViewItem *pListViewItem) { m_pListViewItem = pListViewItem; }
    QListViewItem * getListViewItem() const { return m_pListViewItem; }
    bool isGroup() const { return m_bIsGroup; }
    const QString getSQL(const QString &) const;
    
    // Those functions toggle User right attribute state and return new value
    bool toggleSelect() { m_bSELECT_New = !m_bSELECT_New; return m_bSELECT_New; }
    bool toggleUpdate() { m_bUPDATE_New = !m_bUPDATE_New; return m_bUPDATE_New; }
    bool toggleInsert() { m_bINSERT_New = !m_bINSERT_New; return m_bINSERT_New; }
    bool toggleDelete() { m_bDELETE_New = !m_bDELETE_New; return m_bDELETE_New; }
    bool toggleCreateRule() { m_bRULE_New = !m_bRULE_New; return m_bRULE_New; }
    bool toggleCreateReference() { m_bREFERENCES_New = !m_bREFERENCES_New; return m_bREFERENCES_New; }
    bool toggleCreateTrigger() { m_bTRIGGER_New = !m_bTRIGGER_New; return m_bTRIGGER_New; }
    bool toggleExecute() { m_bEXECUTE_New = !m_bEXECUTE_New; return m_bEXECUTE_New; }
    bool toggleUse() { m_bUSAGE_New = !m_bUSAGE_New; return m_bUSAGE_New; }
    bool toggleCreate() { m_bCREATE_New = !m_bCREATE_New; return m_bCREATE_New; }
    bool toggleCreateTemp() { m_bTEMPORARY_New = !m_bTEMPORARY_New; return m_bTEMPORARY_New; }
    
    bool toggleGrantSelect() { m_bGrantSELECT_New = !m_bGrantSELECT_New; return m_bGrantSELECT_New; }
    bool toggleGrantUpdate() { m_bGrantUPDATE_New = !m_bGrantUPDATE_New; return m_bGrantUPDATE_New; }
    bool toggleGrantInsert() { m_bGrantINSERT_New = !m_bGrantINSERT_New; return m_bGrantINSERT_New; }
    bool toggleGrantDelete() { m_bGrantDELETE_New = !m_bGrantDELETE_New; return m_bGrantDELETE_New; }
    bool toggleGrantCreateRule() { m_bGrantRULE_New = !m_bGrantRULE_New; return m_bGrantRULE_New; }
    bool toggleGrantCreateReference() { m_bGrantREFERENCES_New = !m_bGrantREFERENCES_New; return m_bGrantREFERENCES_New; }
    bool toggleGrantCreateTrigger() { m_bGrantTRIGGER_New = !m_bGrantTRIGGER_New; return m_bGrantTRIGGER_New; }
    bool toggleGrantExecute() { m_bGrantEXECUTE_New = !m_bGrantEXECUTE_New; return m_bGrantEXECUTE_New; }
    bool toggleGrantUse() { m_bGrantUSAGE_New = !m_bGrantUSAGE_New; return m_bGrantUSAGE_New; }
    bool toggleGrantCreate() { m_bGrantCREATE_New = !m_bGrantCREATE_New; return m_bGrantCREATE_New; }
    bool toggleGrantCreateTemp() { m_bGrantTEMPORARY_New = !m_bGrantTEMPORARY_New; return m_bGrantTEMPORARY_New; }
    
    bool canPassGrantToOther() const; // false for GROUP or PUBLIC
    
protected:
    void parsePrivileges(const QString &);
    
protected:
    QString m_strGrantor; // Name of the user that granted the privilege
    QString m_strGrantee; // Name of the user or group that the privilege was granted to
       
    bool m_bIsGroup; // it is group privilege ?
    
    //-- Values loaded from DB server -------------
    // Privileges -------------------
    bool m_bSELECT;     // r ("read")
    bool m_bUPDATE;     // w ("write")
    bool m_bINSERT;     // a ("append")
    bool m_bDELETE;     // d
    bool m_bRULE;       // R
    bool m_bREFERENCES; // x
    bool m_bTRIGGER;    // t
    bool m_bEXECUTE;    // X
    bool m_bUSAGE;      // U
    bool m_bCREATE;     // C
    bool m_bTEMPORARY;  // T 
    
    // GRANT Privileges ---------------
    bool m_bGrantSELECT;     // r ("read")
    bool m_bGrantUPDATE;     // w ("write")
    bool m_bGrantINSERT;     // a ("append")
    bool m_bGrantDELETE;     // d
    bool m_bGrantRULE;       // R
    bool m_bGrantREFERENCES; // x
    bool m_bGrantTRIGGER;    // t
    bool m_bGrantEXECUTE;    // X
    bool m_bGrantUSAGE;      // U
    bool m_bGrantCREATE;     // C
    bool m_bGrantTEMPORARY;  // T 
    
    //-------------------------------------------
    
    //-- Values changed by user -----------------
    // Privileges -------------------
    bool m_bSELECT_New;     // r ("read")
    bool m_bUPDATE_New;     // w ("write")
    bool m_bINSERT_New;     // a ("append")
    bool m_bDELETE_New;     // d
    bool m_bRULE_New;       // R
    bool m_bREFERENCES_New; // x
    bool m_bTRIGGER_New;    // t
    bool m_bEXECUTE_New;    // X
    bool m_bUSAGE_New;      // U
    bool m_bCREATE_New;     // C
    bool m_bTEMPORARY_New;  // T 
    
    // GRANT Privileges ---------------
    bool m_bGrantSELECT_New;     // r ("read")
    bool m_bGrantUPDATE_New;     // w ("write")
    bool m_bGrantINSERT_New;     // a ("append")
    bool m_bGrantDELETE_New;     // d
    bool m_bGrantRULE_New;       // R
    bool m_bGrantREFERENCES_New; // x
    bool m_bGrantTRIGGER_New;    // t
    bool m_bGrantEXECUTE_New;    // X
    bool m_bGrantUSAGE_New;      // U
    bool m_bGrantCREATE_New;     // C
    bool m_bGrantTEMPORARY_New;  // T 
    
    //-------------------------------------------
    
    QListViewItem *m_pListViewItem; // List View item that display this ACL item 
};

typedef QValueList<KPGAclItem> KPGAclItemList;

#endif
