/***************************************************************************
                          kpgbookmarksbutton.cpp  -  description
                             -------------------
    begin                : Ne led 25 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgbookmarksbutton.h"


#include <kaction.h>
#include <klocale.h>
#include <kdebug.h>


KPGBookmarksButton::KPGBookmarksButton(QWidget *parent)
  : KToolBarButton("bookmark", 1000, parent)
{
  setTextLabel(i18n("Open your bookmarks"), true);
  setPopupDelay(10); // 0.01 seconds press
  setAcceptDrops(false);

  KActionMenu *acmBookmarks = new KActionMenu(i18n("Bookmarks"), "bookmark", 0, "bookmarks");
  acmBookmarks->setDelayed(false);

  m_pBookmarkHandler = new KPGBookmarkHandler(this, acmBookmarks->popupMenu());
  QObject::connect(m_pBookmarkHandler, SIGNAL(openUrl(const QString&)), this, SIGNAL(openUrl(const QString&)));
  setPopup(acmBookmarks->popupMenu());
}

KPGBookmarksButton::~KPGBookmarksButton()
{
  delete m_pBookmarkHandler;
}

void KPGBookmarksButton::openPopup()
{
  if(m_pBookmarkHandler->currentTitle().length() == 0)
    m_pBookmarkHandler->enableAddBookmarkMenu(false);
  
  popup()->exec(mapToGlobal(QPoint(0, height())));
}

void KPGBookmarksButton::enableAddBookmarkMenu(bool bEnable)
{
  m_pBookmarkHandler->enableAddBookmarkMenu(bEnable);
}


