/***************************************************************************
                          logbook.cpp  -  description
                             -------------------
    begin                : Wed Jul 12 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include <qvalidator.h>
#include <qlineedit.h>
#include <kglobal.h>
#include <qdatetime.h>
#include <qlabel.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qvaluelist.h>
#include <qstringlist.h>
#include <kstddirs.h>
#include <kmessagebox.h>

#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#include "logbook.h"
#include "globals.h"

logCore* logdb;     /* Logbook database */

logBook::logBook(QWidget *parent, const char *name ) : QWidget(parent,name)
{
	qsoinfo = new QSOInfo (this);
	logdb = new logCore();

	int i;
	QLabel* label;
	QGridLayout* grid = new QGridLayout (this, 1, 1, 5, 5);	

	upperValidator* validator = new upperValidator();

	callEdit = new myQLineEdit (this);
	callEdit->setValidator (validator);
	callEdit->setFixedWidth (75);
  label = new QLabel( callEdit, i18n ("&Call:"), this);
	grid->addWidget (label, 0, 0, Qt::AlignRight);
	grid->addWidget (callEdit, 0, 1);

	nameEdit = new QLineEdit (this);
	nameEdit->setFixedWidth (120);
  label = new QLabel( nameEdit, i18n ("&Name:"), this);
	grid->addWidget (label, 0, 2, Qt::AlignRight);
	grid->addWidget (nameEdit, 0, 3);

	qthEdit = new QLineEdit (this);
  label = new QLabel( qthEdit, i18n ("&QTH:"), this);
	grid->addWidget (label, 0, 4, Qt::AlignRight);

	grid->addMultiCellWidget (qthEdit, 0, 0, 5, 5);

	rstrEdit = new QLineEdit (this);
	rstrEdit->setFixedWidth (35);
	label = new QLabel (rstrEdit, i18n ("&Rcvd:"), this);
	grid->addWidget (label, 0, 6, Qt::AlignRight);
	grid->addWidget (rstrEdit, 0, 7);

	rstsEdit = new QLineEdit (this);
	rstsEdit->setFixedWidth (35);
	label = new QLabel (rstsEdit, i18n ("&Send:"), this);
	grid->addWidget (label, 1, 6, Qt::AlignRight);
	grid->addWidget (rstsEdit, 1, 7);

	notesEdit = new QLineEdit (this);
	label = new QLabel (notesEdit, i18n ("N&otes:"), this);
	grid->addWidget (label, 1, 2, Qt::AlignRight);
	grid->addMultiCellWidget (notesEdit, 1, 1, 3, 5);

	bandEdit = new QComboBox (this);
	for (i=0;i<12;++i)
		bandEdit->insertItem (config.band.band[i], i);
	bandEdit->setCurrentItem (config.logbook.band);
	bandEdit->setFixedWidth (75);
	label = new QLabel (bandEdit, i18n ("&Band:"), this);
	grid->addWidget (label, 1, 0, Qt::AlignRight);
	grid->addWidget (bandEdit, 1, 1);

	QObject::connect (callEdit, SIGNAL (returnPressed()), this, SLOT (slotFocus()));
	QObject::connect (nameEdit, SIGNAL (returnPressed()), this, SLOT (slotFocus()));
	QObject::connect (notesEdit, SIGNAL (returnPressed()), this, SLOT (slotFocus()));
	QObject::connect (qthEdit, SIGNAL (returnPressed()), this, SLOT (slotFocus()));
	QObject::connect (rstrEdit, SIGNAL (returnPressed()), this, SLOT (slotFocus()));
	QObject::connect (rstsEdit, SIGNAL (returnPressed()), this, SLOT (slotFocus()));
	QObject::connect (callEdit, SIGNAL (newText()), this, SLOT (searchLast()));

	clear();
}

logBook::~logBook()
{
	delete logdb;
}

void logBook::slotFocus ()
{
	kpsk->setTXWinFocus();	
}

QString logBook::getBand()
{
	QString str = bandEdit->currentText();
	if (str.isNull()) return "";
	else return str;
}

QString logBook::getCall()
{
	QString str = callEdit->text();
	if (str.isNull()) return "";
	else return str;
}

QString logBook::getName()
{
	QString str = nameEdit->text();
	if (str.isNull()) return "";
	else return str;
}

QString logBook::getNotes()
{
	QString str = notesEdit->text();
	if (str.isNull()) return "";
	else return str;
}

QString logBook::getQth()
{
	QString str = qthEdit->text();
	if (str.isNull()) return "";
	else return str;
}

QString logBook::getRstr()
{
	QString str = rstrEdit->text();
	if (str.isNull()) return "";
	else return str;
}

QString logBook::getRsts()
{
	QString str = rstsEdit->text();
	if (str.isNull()) return "";
	else return str;
}

QString logBook::getDate(bool format)
{
	char time_string[100];
	time_t t;
	struct tm* mytime;

	t = time(0);
	mytime = gmtime (&t);
	if (format==true)
		strftime (time_string, 99, "%Y-%m-%d", mytime);
	else
		strftime (time_string, 99, "%d %b %Y", mytime);
	return QString (time_string);
}

QString logBook::getTime(bool format)
{
	char time_string[100];
	time_t t;
	struct tm* mytime;

	t = time(0);
	mytime = gmtime (&t);
	if (format==true)
		strftime (time_string, 99, "%H:%M:00", mytime);
	else
		strftime (time_string, 99, "%H:%M", mytime);
	return QString (time_string);
}

void logBook::searchLast()
{
	unsigned int i;
	char date[25], time[25];
	time_t t;
	qsoinfo->clearqso();

  // check dxcc exists, if not skip
  if (locate ("appdata", "dxcc.db") != NULL){
	s_dxcc dxcc = logdb->getDxcc (getCall());
	qsoinfo->setInfo(dxcc);
  }

	QList<qso> lastQsos =	logdb->searchCall(getCall());

	lastQsos.setAutoDelete(true);

	if (lastQsos.last()) {
	  for (i=0;i<lastQsos.count();++i) {
			t = lastQsos.at(i)->time();
		  strftime (time, 24, "%H:%M", gmtime(&t));
		  strftime (date, 24, "%d %b %Y", gmtime(&t));
			qsoinfo->insertQSO (lastQsos.at(i)->rsts(), lastQsos.at(i)->rstr(), date, time, lastQsos.at(i)->band());

    }
		nameEdit->setText (lastQsos.last()->name());
		notesEdit->setText (lastQsos.last()->notes());
		qthEdit->setText (lastQsos.last()->qth());
		rstrEdit->setText (lastQsos.last()->rstr());
		rstsEdit->setText (lastQsos.last()->rsts());
	}
}

void logBook::clear()
{
	qsoinfo->clearqso();
	callEdit->setText ("");
	nameEdit->setText ("");
	notesEdit->setText ("");
	qthEdit->setText ("");
	rstrEdit->setText ("");
	rstsEdit->setText ("");	
}

void logBook::append()
{
		logdb->appendQSO (callEdit->text(), nameEdit->text(), qthEdit->text(), rstrEdit->text(), rstsEdit->text(), bandEdit->currentText(), notesEdit->text());
		clear();
		kpsk->callCheckBox->setChecked(config.logbook.callchex);    //ernie
}

void logBook::slotSetCall (QString str)
{
	if (str != getCall()) {
		callEdit->setText (str);  // set the call, erase all other fields
		nameEdit->setText ("");
		notesEdit->setText ("");
		qthEdit->setText ("");
		rstrEdit->setText ("");
		rstsEdit->setText ("");	 // And search in the logbook
		searchLast();
		}
}

void logBook::showQsoInfo (bool state)
{
	if (state)
		qsoinfo->show();
	else
		qsoinfo->hide();
}

