/***************************************************************************
                          logcore.h  -  description
                             -------------------
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef LOGCORE_H
#define LOGCORE_H

#include "../config.h"
#include <qstring.h>
#include <qsortedlist.h>
#include <kstddirs.h>
#ifdef HAVE_LIBDB_4_0
#include <db.h>
#else
#include <db3/db.h>
#endif
#include <stdio.h>


/**Core functions for the logbook
  *@author Luc Langehegermann
  */

/* This structure defines an prefix entry */

typedef struct {
	char country[40];
	int cq;
	int itu;
	char continent[3];
	float longitude;
	float latitude;
	float timezone;
	char prefix[10];
} s_dxcc;

/**
	* This class saves exactle one qso
	*/

class qso {
public:
	qso (QString call="", QString name="", QString qth="", QString rstr="", QString rsts="", QString band="", QString notes="", time_t time=0) {
		_call=call;
		_name=name;
		_qth=qth;
		_rstr=rstr;
		_rsts=rsts;
		_band=band;
		_notes=notes;
		_time=time;
	}
	QString call() {return _call;}
	void call(QString call) {_call=call;}
	QString name() {return _name;}
	void name(QString name) {_name=name;}
	QString qth() {return _qth;}
	void qth(QString qth) {_qth=qth;}
	QString rstr() {return _rstr;}
	void rstr(QString rstr) {_rstr=rstr;}
	QString rsts() {return _rsts;}
	void rsts(QString rsts) {_rsts=rsts;}
	QString band() {return _band;}
	void band(QString band) {_band=band;}
	QString notes() {return _notes;}
	void notes(QString notes) {_notes=notes;}
	time_t time() {return _time;}
	void time(time_t time) {_time=time;}

private:
		QString _call;
		QString _name;
		QString _qth;
		QString _rstr;
		QString _rsts;
		QString _band;
		QString _notes;
		time_t  _time;
};

/* These Operators are used by QSortedList::sort() */

inline	bool operator== (qso &qso1, qso &qso2) {
	if (qso2.time() == qso1.time()) return true; else return false;
};

inline	bool operator< (qso &qso1, qso &qso2) {
	if (qso1.time() > qso2.time()) return true; else return false;
};

class logCore {
public: 
	logCore();
	~logCore();
  s_dxcc getDxcc (QString _call);
	void appendQSO (QString _call, QString _name, QString _qth, QString _rstr, QString _rsts, QString _band, QString _notes, time_t _t=0);
	QSortedList<qso> searchCall (QString _call);
  QSortedList<qso> searchString (QString _str);
  void removeQSO (time_t t);
private:
  DB* dxccdb;
	DB* calldb;
	qso* getQSO (DBT* data, DBT* key);
};

#endif
