void stationDirectoryTree::shoutcast_loadDirectory()
{
  // start fetching the new list
  shoutcast_genreStartNewFileParsing = true;
  shoutcast_genreFound = false;
  shoutcast_genreJob = KIO::get(KUrl("http://www.shoutcast.com/sbin/newxml.phtml"),
                               KIO::Reload,
                               KIO::HideProgressInfo);
  connect(shoutcast_genreJob,
          SIGNAL(data(KIO::Job *, const QByteArray &)),
          this,
          SLOT(shoutcastAddGenres(KIO::Job *, const QByteArray &)));
/*  connect(shoutcastGenreJob,
          SIGNAL(result(KJob *)),
          this,
          SLOT(emitSignalAboutShoutcastGenreFetchingResult()));*/
}

void stationDirectoryTree::shoutcast_addGenres(KIO::Job *sender, const QByteArray &data)
{
  shoutcast_genreXmlSource.setData(data);
  if (shoutcast_genreStartNewFileParsing) {
    shoutcast_genreXmlReader.parse(&shoutcast_genreXmlSource, true);
    shoutcast_genreStartNewFileParsing = false;
  } else {
    shoutcast_genreXmlReader.parseContinue();
  };
}

bool stationDirectoryTree::startElement(const QString & namespaceURI,
                                        const QString & localName,
                                        const QString & qName,
                                        const QXmlAttributes & atts)
{
  // variables
  QTreeWidgetItem *m_item;
  int temp;

  // code
  if (localName == "genre") {
    temp = atts.index("name");
    if (temp >= 0) {
      m_item = new QTreeWidgetItem(this);
      m_item->setText(0, atts.value(temp));
      m_item->setIcon(0, genreIcon);
      shoutcast_genreFound = true;
    };
  };
  return true;  // do not abort the parsing
}

