/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GET_STREAM_INFO_H
#define GET_STREAM_INFO_H

#include "ripping.h"
#include <KDebug>

/** \brief This class detects meta data from streams.
*
* This class calls \e %streamripper, lets it connect to the stream, recognizes
* #streamName, #serverName, #bitrate and #metaInterval and disconnects immediately after that.
*
* Just set the property #serverUri and startStreamripper(). The recognized data is available
* as usual through the properties. */

class get_stream_info : public ripping
{

     Q_OBJECT

     /** This property holds the URI to which \e %streamripper will connect.
     *
     * <b> Initialization value: </b> <EM> an empty string </EM>
     *
     * \li \e read: \code virtual QString serverUri() const \endcode This
     *              (public) function implements <tt>ripping::serverUri()</tt>
     *              (which was originally protected). At the same time it is used
     *              as read function for this property.
     * \li \e write: \code virtual void setServerUri(const QString value) \endcode If
     *              the new value differs from the old one, this function
     *              will also kill() the \e streamripper process (to prevent
     *              that the process continues with the outdated URI) and will
     *              call <tt>resetStreamripperProperties()</tt>.
     *
     * \sa \code qint64 internal_serverUri \endcode */
     Q_PROPERTY(QString serverUri READ serverUri WRITE setServerUri)

  public:
     //contructor(s) and destructor(s)
     /** Constructor of the class.
     * @param parent Sets the parent of this object. */
     get_stream_info(const QPointer<QObject> parent = 0);
     /** The destructor. */
     virtual ~get_stream_info();
     /** See property #serverUri. */
     virtual QString serverUri() const;
     /** See property #serverUri. */
     virtual void setServerUri(const QString value);

  protected:
     /** Returns the parameters which <tt>virtual QStringList
     *   ripping::parameterList() const</tt> would return and
     *   addititionaly a parameter that stops \e %streamripper
     *   directly after the first data is send and
     *   a parameter that prevents \e %streamripper from writing any data. */
     virtual QStringList parameterList() const;

  private:
     /** Used internally to store the property #serverUri. */
     QString internal_serverUri;

};

#endif
