/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "propertyvalue.h"

PropertyValue::PropertyValue()
{
  type = unset;
  formatedValueAlignment = (Qt::AlignLeft | Qt::AlignVCenter);
}

PropertyValue::PropertyValue (const PropertyValue &value)
{
  helper_copyFromHere(value);
}

PropertyValue::~PropertyValue ()
{
}

PropertyValue & PropertyValue::operator=(const PropertyValue & value)
{
  helper_copyFromHere(value);
  return *this;
}

bool PropertyValue::operator==(const PropertyValue value) const
{
  return ((internalValue == value.internalValue)                   &&
           // see Qt documentation for comparation of QVariant...
           (type == value.type)                                     &&
           (formatedValue == value.formatedValue)                   &&
           (formatedValueAlignment == value.formatedValueAlignment) &&
           (toolTip == value.toolTip)                               &&
           (whatsThis == value.whatsThis));
}

bool PropertyValue::operator!=(const PropertyValue value) const
{
  return (!(*this == value));
}

PropertyValue::operator QString() const
{
  return formatedValue;
}

void PropertyValue::helper_copyFromHere (const PropertyValue &value)
{
  internalValue = value.internalValue;
  type = value.type;
  formatedValue = value.formatedValue;
  formatedValueAlignment = value.formatedValueAlignment;
  toolTip = value.toolTip;
  whatsThis = value.whatsThis;
}
