/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "settings_general_dialog.h"

#include "settings_general.h"
#include "settings_general_widget_general.h"
#include "settings_general_widget_saving.h"
#include "settings_general_widget_relayserver.h"

settings_general_dialog::settings_general_dialog(QWidget * parent, const QString name)
  : KConfigDialog(parent, name, settings_general::self())
{
  addPage(new settings_general_widget_saving(this),
          i18nc("@title of a page in the configuration dialog", "Saving"),
          "settings_general_widget_saving");
  addPage(new settings_general_widget_relayserver(this),
          i18nc("@title of a page in the configuration dialog","Relay server"),
          "settings_general_widget_relayserver");
  addPage(new settings_general_widget_general(this),
          i18nc("@title of a page in the configuration dialog","Extended"),
          "settings_general_widget_general");
  showButton(KDialog::Help, false);  // TODO make a help available!
  setModal(true);
}

settings_general_dialog::~settings_general_dialog()
{
}
