/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "listensupport.h"

#include <QTimer>
#include <QCoreApplication>
#include <QEventLoop>

listenSupport::listenSupport(QObject *parent) : QObject(parent)
{
  relayPort = -1;
  station = 0;
  media = new Phonon::MediaObject(this);
  audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory, this);
/*qDebug() << "backend name:" << audioOutput->outputDevice().name() << "description:" <<
    audioOutput->outputDevice().description();
  connect(media, SIGNAL(aboutToFinish ()), this, SLOT(info()));
  connect(media, SIGNAL(currentSourceChanged ( const Phonon::MediaSource & )), this, SLOT(info()));
  connect(media, SIGNAL(finished ()), this, SLOT(info()));
  connect(media, SIGNAL(stateChanged ( Phonon::State , Phonon::State )), this, SLOT(info()));*/
  createPath(media, audioOutput);
/*QTimer *timer = new QTimer(this);
     connect(timer, SIGNAL(timeout()), this, SLOT(info()));
     timer->start(5000);*/
}

listenSupport::~listenSupport()
{
  delete audioOutput;
  delete media;
}

void listenSupport::setStation(radioStation *newStation)
{
  if (newStation != station) {
    if (station) {
      disconnect(station, 0, this, 0);
    };
    // change station
    station = newStation;
    // connect new station
    if (station) {
      connect(station,
              SIGNAL(relayPortChanged(qlonglong, PropertyValue)),
              this,
              SLOT(setRelayPort(qlonglong, PropertyValue)));
      setRelayPort(0, station->relayPort());
      connect(station,
              SIGNAL(destroyed(QObject *)),
              this,
              SLOT(setNoStation()));
    } else {
      setRelayPort(0, PropertyValue());
    };
  };
};

void listenSupport::setNoStation()
{
  setStation(0);
}

void listenSupport::setRelayPort(qlonglong, PropertyValue value)
{
  if (value.type == PropertyValue::value) {
    const qlonglong newPort = value.internalValue.toLongLong();
    if (relayPort != newPort) {
      relayPort = newPort;
      reloadListening();
    };
  } else {
    if (relayPort >= 0) {
      relayPort = -1;
      reloadListening();
    };
  };
}
/**
void listenSupport::info()
{
qDebug() << "output status: mute:"  << audioOutput->isMuted() << "category:" <<
  audioOutput->category() << "name:" << audioOutput->name() << "volume:" <<
  audioOutput->volume() << "volume-decibel" << audioOutput->volumeDecibel();
qDebug() << "media object status: state:" << media->state() << "errorType:" <<
  media->errorType() << "errorString:" << media->errorString() <<
  "current source:" << media->currentSource().url();
qDebug() << "backend name:" << audioOutput->outputDevice().name() <<
  "description:" << audioOutput->outputDevice().description();
}
*/
void listenSupport::reloadListening()
{
/*qDebug() << "stopping...";
  media->stop();
qDebug() << "... done stopping";*/
  if (relayPort >= 0) {
/*qDebug() << "starting" << (QString("http://localhost:%1").arg(relayPort)) << "...";
  delete media;
  delete audioOutput;
  media = new Phonon::MediaObject(this);
  audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory, this);
  createPath(media, audioOutput);
qDebug() << "old source:" << media->currentSource().url();
    media->setCurrentSource(QString("http://localhost:%1").arg(relayPort));
qDebug() << "new source:" << media->currentSource().url();
qDebug() << "will play()";
    media->play();
qDebug() << "...done starting";*/

/*    media->stop();

QTime dieTime = QTime::currentTime().addSecs(2);
while( QTime::currentTime() < dieTime )
	QCoreApplication::processEvents(QEventLoop::AllEvents, 100);
*/
    qDebug() << "status:" << media->state() << "will change source...";  // TODO remove this line
    media->setCurrentSource(QString("http://localhost:%1").arg(relayPort));
    qDebug() << "status:" << media->state() << "will call play()...";  // TODO remove this line
    media->play();
  } else {
    qDebug() << "will call stop()";
    media->stop();
  };
}
