/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef LISTENSUPPORT_H
#define LISTENSUPPORT_H

#include <QPointer>
#include <QList>
#include <phonon/mediaobject.h>
#include <phonon/path.h>
#include <phonon/audiooutput.h>
#include "radiostation.h"

/** \brief Support for listening in streams
*
* This class offers support for listening in streams. The stream who is played (There is only
* \e one stream played at the same time.) can be defined by passing a #radioStation object to
* #setStation().
*
* The class handles autoatically any relevant changes in the #radioStation object (changing
* relay port). You can safely delete the #radioStation object. Playback stops in this case. */
class listenSupport : public QObject
{

  Q_OBJECT

  public:
    /** The constructor.
    * \param parent The parent of this object. */
    listenSupport(QObject *parent = 0);
     /** The destructor. */
    virtual ~listenSupport();

  public slots:
    /** Determinates the #station where to listen.
    * \param newStation The corresponding #radioStation object. You can
    * pass a \e NULL pointer here to disable listening in. */
    void setStation(radioStation *newStation);
    /** Conveniance function that calls \code setStation(0) \endcode */
    void setNoStation();

  private:
    /** The audio output object. */
    Phonon::AudioOutput *audioOutput;
    /** The media object. */
    Phonon::MediaObject *media;
    /** If it is \e NULL, than no listening in is desired. Else,
    * listening in is desired for the specified station.
    * \note This can not be a QPointer, because in this case it would be,
    * if the #radioStation object is destroyed, reset to 0 \e before
    * the slot #setNoStation() is called. However, in this case there would
    * be no reload done. */
    radioStation *station;
    /** The actual relay port.
    * \sa #setRelayPort */
    qlonglong relayPort;
    /** Stops the playback. If a valid relayPort (>=0) is given,
    * playback is than restarted for this relay port. */
    void reloadListening();

  private slots:
    /** Sets the relay port. If it is necessary that the playback changes,
    * these changes are done.
    * \param ignored This argument is ignored.
    * \param value The new value
    * \sa #relayPort */
    void setRelayPort(qlonglong ignored, PropertyValue value);
    //void info();
};

#endif
