/***************************************************************************
             documentsaverdb - save documents to the database
                             -------------------
    begin                : 2006-02-21
    copyright            : (C) 2005 by Klaas Freitag
    email                : freitag@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DOCUMENTSAVERDB_H
#define _DOCUMENTSAVERDB_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "documentsaverbase.h"

// include files
#include <qobject.h>

/**
 *
 */
class KraftDoc;
class QSqlRecord;
class dbID;

class DocumentSaverDB : public DocumentSaverBase
{
    Q_OBJECT

public:
    DocumentSaverDB();
    virtual ~DocumentSaverDB();

    virtual bool saveDocument( KraftDoc* );
    virtual void load( const QString& , KraftDoc * );
    QString generateDocumentIdent( dbID, KraftDoc* ) const;
protected:
    virtual void loadPositions( const QString&, KraftDoc* );
    virtual void saveDocumentPositions( KraftDoc* );
private:

    void fillDocumentBuffer( QSqlRecord*, KraftDoc* );
};

#endif

/* END */

