/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkaaddressdata.h"

#include <qdom.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>

using namespace KKAddressBook;

KKAAddressData::KKAAddressData( QObject* parent
							  , LocationType l
							  )
 : QObject( parent )
 , m_locationType( l )
 , m_country( KGlobal::locale()->country() )
 , m_zipcode( QString::null )
 , m_address( QString::null )
 , m_printStatus( None )
{
}



KKAAddressData::KKAAddressData( QObject* parent
							  , LocationType l
							  , const QString& c
							  , const QString& z
							  , const QString& a
							  , PrintStatus p
							  )
 : QObject( parent )
 , m_locationType( l )
 , m_preference( false )
 , m_country( c )
 , m_zipcode( z )
 , m_address( a )
 , m_printStatus( p )
{
}

KKAAddressData::KKAAddressData( QObject* parent, QDomElement& e )
 : QObject( parent )
 , m_locationType( (LocationType)e.attribute( "locationType" ).toInt() )
 , m_preference( e.hasAttribute( "preference" ) ? e.attribute( "preference" ) == "True" : false )
 , m_country( e.attribute( "country" ) )
 , m_zipcode( e.attribute( "zipcode" ) )
 , m_address( e.attribute( "address" ) )
 , m_printStatus( e.hasAttribute( "printStatus" ) ? (PrintStatus)e.attribute( "printStatus" ).toInt() : None )
{
	if( m_country.isEmpty() ) m_country = KGlobal::locale()->country();
}

KKAAddressData::~KKAAddressData()
{
}

QDomElement KKAAddressData::toElement( QDomDocument& doc )
{
	QDomElement elem = doc.createElement( tagName() );
	elem.setAttribute( "locationType", m_locationType );
	if( m_preference ) elem.setAttribute( "preference", "True" );
	elem.setAttribute( "country", m_country );
	elem.setAttribute( "zipcode", m_zipcode );
	elem.setAttribute( "address", m_address );
	elem.setAttribute( "printStatus", m_printStatus );
	return elem;
}

void KKAAddressData::setLocationType( LocationType l )
{
	if( m_locationType == l ) return;
	m_locationType = l;
}

void KKAAddressData::setPreference( bool p )
{
	if( m_preference == p ) return;
	m_preference = p;
}

void KKAAddressData::setCountry( const QString& c )
{
	if( m_country == c ) return;
	m_country = c;
	emit updated();
}

void KKAAddressData::setZipcode( const QString& z )
{
	if( m_zipcode == z ) return;
	m_zipcode = z;
	emit updated();
}

void KKAAddressData::setAddress( const QString& a )
{
	if( m_address == a ) return;
	m_address = a;
	emit updated();
}

void KKAAddressData::setPrintStatus( PrintStatus p )
{
	if( m_printStatus == p ) return;
	m_printStatus = p;
	emit printStatusChanged( m_printStatus );
}
