/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKADETAILVIEW_H_
#define _KKADETAILVIEW_H_

#include <qvbox.h>
#include <qvaluelist.h>

class QListViewItem;
class KTabWidget;
class KLineEdit;

namespace KKAddressBook
{
	class KKAPersonWidget;
	class KKAAddressWidget;
	class KKAContactData;
	class KKAPerson;
	class KKAPrintStatusWidget;

	class KKADetailView : public QVBox
	{
		Q_OBJECT
	public:
		KKADetailView( QWidget* parent = 0, const char* name = 0 );
		virtual ~KKADetailView();

	public slots:
		void setData( QListViewItem* data );

	private slots:
		void setPreference();
		void setName( const QString& str );

	private:
		void setupWidgets();

		KKAPerson* m_data;

		KKAPersonWidget* m_person;
		KTabWidget* m_tab;
		KKAAddressWidget* m_home;
		QValueList<KKAPersonWidget*> m_jointNames;
		KLineEdit* m_corporation;
		KLineEdit* m_section;
		KLineEdit* m_post;
		KKAAddressWidget* m_office;
		KKAPrintStatusWidget* m_homePrintStatus;
		KKAPrintStatusWidget* m_officePrintStatus;
	};
}

#endif /* _KKADETAILVIEW_H_ */
