/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDCATEGORYMENU_H_
#define _KKDCATEGORYMENU_H_

#include <qmap.h>
#include <qpopupmenu.h>
#include <qdom.h>

namespace KKDSubscribeTemplate
{
	class KKDCategoryItem;
	class KKDCategoryMenu : public QPopupMenu
	{
		Q_OBJECT
		public:
			KKDCategoryMenu( QWidget* parent = 0, const char* name = 0 );
			virtual ~KKDCategoryMenu();
			void setItem( KKDCategoryItem* item );
			void setID( int id ){ m_id = id; }

		signals:
			void decided( int, const QString&, const QString& );

		private slots:
			void slotDecided( int, const QString&, const QString& );
			void slotActivated( int );

		private:
			int m_id;
			QMap<int,QString> m_strPaths;
	};
}
#endif /* _KKDCATEGORYMENU_H_ */
