/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDSUBSCRIBETEMPLATEDIALOG_H_
#define _KKDSUBSCRIBETEMPLATEDIALOG_H_

#include <kdialogbase.h>
#include <kpushbutton.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <qcheckbox.h>
#include <qvaluelist.h>
#include <qlabel.h>

namespace KKDSubscribeTemplate
{
	class KKDCategoryButton;

	class KKDSubscribeTemplateDialog : public KDialogBase
	{
		Q_OBJECT
	public:
		KKDSubscribeTemplateDialog( const QString& filename, QWidget* parent = 0, const char* name = 0 );
		virtual ~KKDSubscribeTemplateDialog();
		void addPixmap( const QPixmap& pix );

	public slots:
		void slotOk();

	private:
		QString m_filename;

		KKDCategoryButton* m_btnCategory;
		QCheckBox* m_chkSuggest;
		KLineEdit* m_txtNewCategory;
		KLineEdit* m_txtTitle;
		QLabel* m_label;
		QPixmap m_preview;
		KTextEdit* m_txtComment;
		KLineEdit* m_txtName;
		KLineEdit* m_txtMail;
		QCheckBox* m_chkAccept;

		QMap<int,QPopupMenu*> m_menus;
		QPopupMenu* m_popup;

		QPopupMenu* readCategory();
		bool isError();
		bool send();
		void setupWidgets();
		QPixmap scaleChange( const QPixmap& pix, int i ){ return scaleChange( pix, QSize( i, i ) ); }
		QPixmap scaleChange( const QPixmap& pix, const QSize& s );

	private slots:
		void suggestChanged();
	};
}
#endif /* _KKDSUBSCRIBETEMPLATEDIALOG_H_ */
