/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDTEXTBASE_H_
#define _KKDTEXTBASE_H_

#include "kkditembase.h"

namespace KKDesigner
{
	class KKDTextBase : public KKDItemBase
	{
		Q_OBJECT
		Q_PROPERTY( QFont font READ font )
		Q_PROPERTY( QString fontFamily READ fontFamily WRITE setFontFamily )
		Q_PROPERTY( int fontSize READ fontSize WRITE setFontSize )
		Q_PROPERTY( bool fontBold READ fontBold WRITE setFontBold )
		Q_PROPERTY( bool fontItalic READ fontItalic WRITE setFontItalic )
		Q_PROPERTY( bool fontUnderline READ fontUnderline WRITE setFontUnderline )
		Q_PROPERTY( bool fontStrikeOut READ fontStrikeOut WRITE setFontStrikeOut )
		Q_PROPERTY( QColor color READ color WRITE setColor )
		Q_PROPERTY( Orientation orientation READ orientation WRITE setOrientation )
	public:
		KKDTextBase( const QPoint& l
				   , const QSize& s
				   , const QFont& f
				   , const QColor& c
				   , Orientation o
				   , QObject* parent = 0
				   );
		KKDTextBase( QDomElement e, QObject* parent = 0 );
		KKDTextBase( const KKDTextBase* item, QObject* parent = 0 );
		~KKDTextBase();

		static const QString tagName(){ return QString( "Base" ); }
		QDomElement toElement( QDomDocument& doc, const QString& t = QString::null );

		//BEGIN Properties
		virtual ItemType type() const = 0;

		const QFont& font() const { return m_font; }
		QString fontFamily() const { return m_font.family(); }
		int fontSize() const { return m_font.pointSize(); }
		bool fontBold() const { return m_font.bold(); }
		bool fontItalic() const { return m_font.italic(); }
		bool fontUnderline() const { return m_font.underline(); }
		bool fontStrikeOut() const { return m_font.strikeOut(); }
		const QColor& color() const { return m_color; }
		Orientation orientation() const { return m_orientation; }
		//END   Properties

	public slots:
		//BEGIN Properties
		void setFontFamily( const QString& f );
		void setFontSize( int s );
		void setFontBold( bool b );
		void setFontItalic( bool i );
		void setFontUnderline( bool u );
		void setFontStrikeOut( bool s );
		void setColor( const QColor& c );
		void setOrientation( Orientation o );
		//END   Properties

	signals:
		//BEGIN Properties
		void fontFamilyChanged();
		void fontSizeChanged();
		void fontBoldChanged();
		void fontItalicChanged();
		void fontUnderlineChanged();
		void fontStrikeOutChanged();
		void colorChanged();
		void orientationChanged();
		//END   Properties

	protected:
		virtual void drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );
		virtual void drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );

		QString toVertical( const QString& str );
		QSize calcSize( const QString& str, int size_decrease = 0 );
		void drawText( QRect& r, QPainter& p, AlignmentFlags align, const QString& str, int size_decrease = 0 );

		virtual void refontsize(){}
		virtual void resize(){}

	private:
		QFont m_font;
		QColor m_color;
		Orientation m_orientation;

	};
}

#endif /* _KKDTEXTBASE_H_ */
