/***************************************************************************
                          kmylistview.cpp  -  description
                             -------------------
    begin                : Mit M� 27 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmylistview.h"
#include "myinputdialog.h"

// KDE includes
#include <kiconloader.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <krun.h>

KMyListView::KMyListView( QValueList<manualchanges>* _changes, KMyListBox* _list, QWidget* parent, const char* name )
    :KListView(parent, name )
{
    changes = _changes;
    list = _list;

    connect( this, SIGNAL( doubleClicked(QListViewItem*, const QPoint&, int) ),
        this, SLOT( changeItem(QListViewItem*, const QPoint&, int) ) );
    connect( this, SIGNAL( contextMenuRequested(QListViewItem*, const QPoint&, int) ),
        this, SLOT( showContext(QListViewItem*, const QPoint&, int) ) );
    setAllColumnsShowFocus( true );
}

KMyListView::~KMyListView()
{ }


void KMyListView::changeItem( QListViewItem* item, const QPoint&, int )
{
    if(!item) return;

    KURL url = list->url( itemIndex( item ) );

    bool revertenable = false;
    QValueList<manualchanges>::iterator it;
    for ( it = changes->begin(); it != changes->end(); ++it )
        if( (*it).url == url ) {
            changes->remove( it );
            revertenable = true;
            break;
        }


    MyInputDialog i( item->text( 1 ), revertenable );
    i.setInputFilename( item->text( 0 ) );

    int code = i.exec();
    if( code == MyInputDialog::OK ) {
        manualchanges tmp = {
            url,
            i.filename()
        };

        changes->append( tmp );
        emit itemChanged();
    } else if( code == MyInputDialog::USE_KRENAME )
        emit itemChanged();
}

void KMyListView::showContext( QListViewItem* item, const QPoint& pos, int )
{
    KPopupMenu* menu = new KPopupMenu( this );
    if(item) {
        menu->insertTitle( list->text( itemIndex( item ) ), 0, 0 );
        menu->insertItem( i18n("&Change Filename Manually"), this, SLOT( changeCurrentItem() ), Key_F2 );
        menu->insertSeparator();
        menu->insertItem( BarIcon("exec"), i18n("Open"), this, SLOT( openCurrent() ) );
        menu->insertSeparator();
    }
    menu->insertItem( BarIcon("fileopen"), i18n("&Add..."), this, SLOT( addFiles() ) );
    if(item)
        menu->insertItem( BarIcon("editdelete"), i18n("&Remove"), this, SLOT( removeCurrentItem() ) );
            
    menu->popup( pos );
}

void KMyListView::removeCurrentItem()
{
    int index = itemIndex( currentItem() );
    emit removeItem( index );    
}

void KMyListView::addFiles()
{
    emit addFile();
}

void KMyListView::changeCurrentItem()
{
    changeItem( currentItem(), QPoint( 0, 0 ), 0 );
}

void KMyListView::openCurrent()
{
    if( currentItem() )
        new KRun( list->text( itemIndex( currentItem() ) ) );
}

/////////////////////////////////////////////////////////////

KMyListViewItem::KMyListViewItem(QListView *parent)
  : KListViewItem(parent)
{ }

KMyListViewItem::KMyListViewItem(QListViewItem *parent)
  : KListViewItem(parent)
{ }

KMyListViewItem::KMyListViewItem(QListView *parent, QListViewItem *after)
  : KListViewItem(parent, after)
{ }

KMyListViewItem::KMyListViewItem(QListViewItem *parent, QListViewItem *after)
  : KListViewItem(parent, after)
{ }

KMyListViewItem::KMyListViewItem(bool m, QListView *parent,
    QString label1, QString label2, QString label3, QString label4,
    QString label5, QString label6, QString label7, QString label8)
  : KListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8)
{
    modified = m;
}

KMyListViewItem::KMyListViewItem(bool m, QListViewItem *parent,
    QString label1, QString label2, QString label3, QString label4,
    QString label5, QString label6, QString label7, QString label8)
  : KListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8)
{
    modified = m;
}

KMyListViewItem::KMyListViewItem(bool m, QListView *parent, QListViewItem *after,
    QString label1, QString label2, QString label3, QString label4,
    QString label5, QString label6, QString label7, QString label8)
  : KListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
{
    modified = m;
}

KMyListViewItem::KMyListViewItem(QListViewItem *parent, QListViewItem *after,
    QString label1, QString label2, QString label3, QString label4,
    QString label5, QString label6, QString label7, QString label8)
  : KListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
{ }

KMyListViewItem::~KMyListViewItem()
{ }

void KMyListViewItem::paintCell( QPainter *p, const QColorGroup &cg,
                                int column, int width, int alignment )
{
    QColorGroup _cg( cg );
    QColor c = _cg.text();
    if( modified )
        _cg.setColor( QColorGroup::Text, Qt::red );

    KListViewItem::paintCell( p, _cg, column, width, alignment );
    _cg.setColor( QColorGroup::Text, c );
}

