//
// C++ Implementation: translitplugin
//
// Description: 
//
//
// Author: Dominik Seichter <domseichter@web.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "translitplugin.h"
#include "translitplugin.moc"

const QString TranslitPlugin::m_strUtf8[] = {"а","б","в","г","д","е","ё","ж","з","и",
    "й","к","л","м","н","о","п","р","с","т","у","ф","х","ц","ч","ш","щ","ъ","ы","ь",
    "э","ю","я",
    "А","Б","В","Г","Д","Е","Ё","Ж","З","И","Й","К","Л","М","Н","О","П",
    "Р","С","Т","У","Ф","Х","Ц","Ч","Ш","Щ","Ъ","Ы","Ь","Э","Ю","Я",QString::null};
    
const QString TranslitPlugin::m_strEngl[]= {"a","b","v","g","d","e","yo","zh","z","i",
    "j","k","l","m","n","o","p","r","s","t","u","f","h","c","ch","sh","sh","","y","",
    "e","yu","ya",
    "A","B","V","G","D","E","Yo","Zh","Z","I","J","K","L","M","N","O","P",
    "R","S","T","U","F","H","C","Ch","Sh","Sh","","Y","","E","Yu","Ya",QString::null};

const QString TranslitPlugin::getName() const
{
    return i18n("Transliteration Plugin");
}

const QString TranslitPlugin::getAccelName() const
{
    return i18n("&Transliteration Plugin");
}

const QPixmap TranslitPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "fonts", KIcon::Small );
}

const int TranslitPlugin::type() const
{
    return TYPE_FINAL_FILENAME;
}

void TranslitPlugin::drawInterface( QWidget* w, QVBoxLayout* l )
{
    QLabel* label = new QLabel( 
    i18n("<qt>This plugin transliterates names written with non-english characters.</qt>"), w );
    l->addWidget( label );
    
    label = new QLabel( "<qt><b>WARNING! THIS PLUGIN IS EXPERIMENTAL AND MIGHT CAUSE LOSS OF DATA!</b></qt>", w );
    l->addWidget( label );
}

void TranslitPlugin::finished()
{
}

void TranslitPlugin::fillStructure()
{
} 

bool TranslitPlugin::checkError()
{
   return true;
}

QString TranslitPlugin::processFile( BatchRenamer*, int, QString token, int )
{
    QString output = translit( token );

    return output; // no error
}

QString TranslitPlugin::translit(const QString & unicoded)
{
    int i;
    QString transed = "";
    
    for (i=0; i<(int)unicoded.length(); i++) {
        QString charIn = unicoded.mid(i, 1);
        if (m_mapFromUTF8[charIn.utf8()]) {
            QString charTrans = m_mapFromUTF8[charIn.utf8()];
            transed.append(charTrans);
        } else {
            transed.append(charIn);
        }
    }
    return transed;
}

TranslitPlugin::TranslitPlugin() {
    // Initialize transliteration map
    int i;
    for (i=0; m_strUtf8[i]!=QString::null; i++) {
        QString src = m_strUtf8[i];
        QString dst = m_strEngl[i];
        m_mapFromUTF8[src] = dst;
    }
}
