/***************************************************************************
                          fileplugin.cpp  -  description
                             -------------------
    begin                : Mon Jul 1 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fileplugin.h"

// Qt includes
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qregexp.h>

// KDE includes
#include <kapplication.h>
#include <kfilemetainfo.h>
#include <klineedit.h>
#include <klistbox.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kpushbutton.h>

FilePlugin::FilePlugin( KService* service )
{
    if(!service) {
        setupKeys();
        return;
    }
        
    KFileMetaInfoProvider* mip = KFileMetaInfoProvider::self();
    m_name = service->name();
    m_comment = service->comment();
    QStringList options = service->serviceTypes();
    for( unsigned int i = 0; i < options.count(); i++ ) {
        if( options[i] != "KFilePlugin" ) {
            m_mimetype = options[i];
            const KFileMimeTypeInfo* info = mip->mimeTypeInfo( m_mimetype );
            if( info )               
                keys = info->supportedKeys();

            fileplugin = mip->plugin( m_mimetype );
           
            KMimeType::Ptr mime = KMimeType::mimeType( m_mimetype );
            m_icon = mime->icon( QString::null, true );  // arguments are unused
            
            setPattern( mime );
        }
    }
}

FilePlugin::~FilePlugin()
{ }

void FilePlugin::setPattern( KMimeType::Ptr mime )
{
    QStringList pattern = mime->patterns();
    if( pattern.count() ) {
        m_pattern = pattern[0];
        if( m_pattern.startsWith( "*." ) )
            m_pattern = m_pattern.right( m_pattern.length() - 2 );
    }
    
    // TODO: REFACTOR
    // We need a pattern
    if( m_pattern.isEmpty() ) {
        int a = 0;
        a = m_name.find( "-" );
        if( a > -1 )
            m_pattern = m_name.left( a ).lower();
        else {
            a = m_pattern.find( " " );
            if( a > -1 )
                m_pattern = m_name.left( a ).lower();
            else 
                m_pattern = m_name;
        }
    }
    
    setupKeys();
}

void FilePlugin::setupKeys()
{
    for( unsigned int i = 0; i < keys.count(); i++ ) 
        keys[i] = getPattern() + keys[i];
}

const QString FilePlugin::getName() const
{
    return m_name;
}

const QString FilePlugin::getAccelName() const
{
    return "&" + getName();
}

const QString FilePlugin::getPattern() const
{
    return m_pattern;
}

const int FilePlugin::type() const
{
    return TYPE_BRACKET;
}

bool FilePlugin::checkError()
{
    return true;
}

void FilePlugin::drawInterface( QWidget* w, QVBoxLayout* l )
{
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Expanding );
    
    QHBoxLayout* hbox = new QHBoxLayout( 0, 6, 6 );
    
    QLabel* pix = new QLabel( w );
    pix->setPixmap( kapp->iconLoader()->loadIcon( m_icon, KIcon::Desktop ) );
    
    hbox->addWidget( pix );
    hbox->addWidget( new QLabel( "<qt><b>"+getName()+"</b></qt>", w ) );
    hbox->addItem( spacer );

    l->addLayout( hbox );    
    l->addWidget( new QLabel( m_comment, w ) );
    l->addWidget( new QLabel( i18n("Supported tokens:"), w ) );

    KListBox* list = new KListBox( w );
    list->setColumnMode( KListBox::FitToWidth );

    for( unsigned int i = 0; i < keys.count(); i++ )
        list->insertItem( "[" + keys[i] + "]" );
    
    l->addWidget( list );
    l->setStretchFactor( list, 2 );
}

QString FilePlugin::processFile( BatchRenamer* b, int i, QString token, int )
{
    QString filename = BatchRenamer::buildFilename( &b->files()[i].src );
    
    token = token.lower();

    /*
     * Check if we have something cached for this file
     */
    if( cache.contains( filename + "::" + token ) )
        return cache[filename + "::" + token ];

    for( unsigned int i = 0; i < keys.count(); i++ ) {
        if( token.lower() == keys[i].lower() ) {
            KFileMetaInfo meta( filename );
            if( meta.isValid() ) {
                QString k = keys[i];
                if( k.startsWith( getPattern() ) )
                    k = k.mid( getPattern().length(), k.length() - getPattern().length() );
                    
                QString ret = meta.item( k ).string( true ).stripWhiteSpace();

                if( cache.count() >= CACHE_MAX )
                    cache.remove( cache.begin() );

                cache.insert( filename + "::" + token, ret );
                kapp->processEvents();
                return ret;                    
            }
        }
    }
    
    return QString::null;
}

void FilePlugin::addHelp( HelpDialogData* data )
{
    QStringList list;
    for( unsigned int i = 0; i < keys.count(); i++ ) 
        list.append( "[" + keys[i] + "]" + ";;" + keys[i] );
    
    data->add( getName(), &list, getIcon() );
}

const QPixmap FilePlugin::getIcon() const 
{
    return kapp->iconLoader()->loadIcon( m_icon, KIcon::Small );
}

bool FilePlugin::supports( const QString & token )
{
    for( unsigned int i = 0; i < keys.count(); i++ )
        if( QRegExp( keys[i].lower() ).exactMatch( token.lower() ) )
            return true;
            
    return false;
}

void FilePlugin::clearCache()
{
    cache.clear();
}
