/***************************************************************************
                          helpdialog.h  -  description
                             -------------------
    begin                : Fr Nov 15 13:44:19 CEST 2001
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HELPDIALOG_H
#define HELPDIALOG_H

#include <qdialog.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qmap.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QComboBox;
class QLineEdit;
class QPixmap;
class KListView;
class KPushButton;

class HelpDialogData : public QObject {
    Q_OBJECT
    public:
        HelpDialogData() {}
        ~HelpDialogData() {}
        
        void add( const QString & headline, QStringList* commands, const QPixmap & icon, bool first = false );
        void remove( const QString & headline );
        
        /** returns all available and supported tokens 
          */
        QStringList tokens() const;
    
        inline const QMap<QString,QStringList> & map() const
        {
            return m_map;
        }
        
        inline const QMap<QString,QPixmap> & icons() const
        {
            return m_icons;
        }
        
        inline const QString & first() const 
        {
            return m_first;
        }
        
    signals:
        void updateHeadline();
        void updateItems();
        
    private:
        QMap<QString,QStringList> m_map;
        QMap<QString,QPixmap> m_icons;
    
        QString m_first;
};

class HelpDialog : public QDialog
{ 
    Q_OBJECT
    public:
        HelpDialog( HelpDialogData* data, QWidget* parent = 0,
            const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~HelpDialog();

        inline void setLineEdit( QLineEdit* lineedit );

    public slots:
        void updateItems();
        void updateHeadline();
        
    private slots:
        void execute();

    private:        
        QComboBox* comboHeadline;
        KListView* list;
        KPushButton* buttonAdd;
        KPushButton* buttonClose;

    protected:
        HelpDialogData* m_data;
        
        QLineEdit* text;

        QVBoxLayout* HelpDialogLayout;
        QHBoxLayout* Layout1;
};

void HelpDialog::setLineEdit( QLineEdit* lineedit )
{ 
     text = lineedit; 
}

#endif // HELPDIALOG_H
