/***************************************************************************

                          threadedlister.cpp  -  description
                             -------------------
    begin                : Tue Feb 01 2005
    copyright            : (C) 2005 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "threadedlister.h"

#include "kmylistbox.h"
#include "krecursivelister.h"

#include <kapplication.h>
#include <qmutex.h>

ThreadedLister::ThreadedLister( QMutex* mutex, KMyListBox* list  )
 : QObject(), QThread(), m_mutex( mutex ), m_list( list )
{
    m_reclister = NULL;
    m_lister = NULL;
    m_internal = NULL;

    m_hidden = false;
    m_recursive = false;
    m_dirnames = false;
    m_dironly = false;
}


ThreadedLister::~ThreadedLister()
{
    if( m_reclister )
        delete m_reclister;
        
    if( m_lister )
        delete m_lister;
        
    if( m_internal )
        delete m_internal;
}

void ThreadedLister::run()
{
    m_internal = new QMutex();
    m_internal->lock();
    
    if( m_recursive ) 
    {
        m_reclister = new KRecursiveLister();
        
        m_reclister->setShowingDotFiles( m_hidden );
        m_reclister->setNameFilter( m_filter );
        m_reclister->setDirOnlyMode( m_dironly );
                
        connect( m_reclister, SIGNAL( completed() ), this, SLOT( reclisterFinished() ) );
        
        m_reclister->openURL( m_dirname );
    } else {
        m_lister = new KDirLister();
    
        m_lister->setAutoUpdate( false );
        m_lister->setShowingDotFiles( m_hidden );
        m_lister->setNameFilter( m_filter );
        
        connect( m_lister, SIGNAL( completed() ), this, SLOT( listerFinished() ) );
        
        m_lister->openURL( m_dirname, false, false );    
    }
    
    // try to lock the mutex.
    // This will block run as long as *listerFinished() 
    // does not unlock the mutex.
    m_internal->lock();
    m_internal->unlock();
    
    KApplication::postEvent( m_list, new QCustomEvent( (QEvent::Type)ThreadedLister::TYPE(), (void*)this ) );
}


void ThreadedLister::reclisterFinished()
{
    KFileItemList l = m_reclister->items();
    FileList list = l;
    
    if( m_dirnames ) 
    {
        FileList dirs = m_reclister->dirs();
        KFileItem* item;
        for( item = dirs.first(); item; item = dirs.next() )
            list.append( item );
    }

    list.sort();

    m_mutex->lock();
    m_list->setUpdatesEnabled( false );

    if( m_dirnames ) 
    {
        QString name = m_dirname.fileName();
        if( !m_hidden && name.right( 1 ) != QString::fromLatin1(".") )        
            m_list->addDirName( m_dirname );
    }
    
    KFileItem* item;
    for( item = list.first(); item; item = list.next() )
        if( item->isFile() )
            m_list->addFile( item->url(), true );
        else if( item->isDir() )
            m_list->addDirName( item->url() );
            
    m_mutex->unlock();
    m_list->setUpdatesEnabled( true );
    
    m_internal->unlock();
}

void ThreadedLister::listerFinished()
{
    if( m_lister->isFinished() ) {
        FileList list = m_lister->items( KDirLister::FilteredItems );
        list.sort();

        m_mutex->lock();
        m_list->setUpdatesEnabled( false );
        
        if( m_dirnames ) 
        {
            QString name = m_dirname.fileName();
            if( !m_hidden && name.right( 1 ) != QString::fromLatin1(".") )        
                m_list->addDirName( m_dirname );
        }
        
        KFileItem* item;
        for( item = list.first(); item; item = list.next() )
            if( item->isFile() )
                m_list->addFile( item->url(), true );

        m_mutex->unlock();
        m_list->setUpdatesEnabled( true );
        
        m_internal->unlock();
    }
}

#include "threadedlister.moc"
