/***************************************************************************
                          kmyhistorycombo.h  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYHISTORYCOMBO_H
#define KMYHISTORYCOMBO_H

// KDE includes
#include <kcombobox.h>
#include <kcompletion.h>

class QTimer;

class KMyHistoryCombo : public KHistoryCombo  {
    Q_OBJECT
    public:
        KMyHistoryCombo(QWidget* parent=0, const char* name=0);
        ~KMyHistoryCombo();

        /**
         * Saves the settings of the HistoryCombo in the applications
         * config file in a group named name()
         * Saved settings include:
         * - history items
         * - completion items
         * - completion mode
         */
        void saveSettings();
        
        inline QString text() const;

        QString text( int index ) const;

        void setText( const QString & text );
        void add( const QString & text );
        bool isEmpty() const;
        
    signals:
        void delayedTextChanged();
        
    private slots:
        void textChangedGovernor();
        
    private:
        QTimer* m_timer;
};

inline QString KMyHistoryCombo::text() const
{ 
    return currentText(); 
}

#endif
