<?php
/**
 * $Horde: kronolith/prefs.php,v 1.13.2.6 2003/04/04 19:23:53 chuck Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Call PrefsUI::groupIsEditable() here because we can rely on it being present
 * in Horde 2.1 but the prefs template still calls groupIsEditable().
 */
function groupIsEditable($group)
{
    return PrefsUI::groupIsEditable($group);
}

function handle_category_management($updated)
{
    global $prefs;

    $actionID = Horde::getFormData('managementActionID');
    $categoryID = Horde::getFormData('category_id');
    $categoryName = Horde::getFormData('category_name');
    $newcolors = Horde::getFormData('newColors');

    /* Always save colors. */
    $event_colors = '';
    foreach ($newcolors as $key => $color) {
        $event_colors .= (empty($event_colors)) ? "$key:$color" : "|$key:$color";
    }
    $prefs->setValue('event_colors', $event_colors);

    switch ($actionID) {
        case KRONOLITH_DELETE_CATEGORY:
            Kronolith::deleteCategory($categoryID);
            break;

        case KRONOLITH_RENAME_CATEGORY:
            Kronolith::renameCategory($categoryID, $categoryName);
            break;

        case KRONOLITH_ADD_CATEGORY:
            Kronolith::addCategory($categoryName);
            break;

        default:
            /* Must have been the Save button. */
            $update = true;
            return true;
    }

    /* Return false so it stays on this page. */
    return false;
}

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require KRONOLITH_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    include KRONOLITH_BASE . '/config/prefs.php';
}

$title = _("User Options");
require KRONOLITH_TEMPLATES . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';
$notification->notify();

/* Assign variables for select lists. */
if (!$prefs->isLocked('timezone')) {
    $timezone_options = &$tz;
}
if (!$prefs->isLocked('day_hour_start') || !$prefs->isLocked('day_hour_end')) {
    $day_hour_start_options = array();
    for ($i = 0; $i <= 48; $i++) {
        $day_hour_start_options[$i] = date(($prefs->getValue('twentyFour')) ? 'G:i' : 'g:ia', mktime(0, $i * 30, 0));
    }
    $day_hour_end_options = $day_hour_start_options;
}

/* Show the UI. */
PrefsUI::generateUI($group);

$registry->shutdown();
require KRONOLITH_TEMPLATES . '/common-footer.inc';
