<?php
/*
 * $Horde: kronolith/data.php,v 1.16.2.2 2003/01/03 12:49:05 jan Exp $
 *
 * Copyright 2001-2003 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Data.php';

if (!$conf['menu']['import_export']) {
    header('Location: ' . Horde::applicationUrl('index.php', true));
    exit;
}

$error = false;
$actionID = Horde::getFormData('actionID', NOOP);

if ($actionID == HORDE_IMPORT) {
    $importID = Horde::getFormData('importID');
    $dates = array();
    
    if ($importID == IMPORT_MAPPED) {
        include_once HORDE_BASE . '/lib/SessionCache.php';
        $cache = new SessionCache();
        $cacheID = Horde::getFormData('cacheID');
        
        if (!isset($cacheID) || !(list($importData, $appFields) = $cache->getObject($cacheID))) {
            $notification->push(_("The data was lost."), 'horde.error');
            $error = true;
        } else {
            $import_type = Horde::getFormData('import_type');
            $dataKeys = Horde::getFormData('dataKeys', '');
            $dataKeys = explode("\t", $dataKeys);
            $appKeys = Horde::getFormData('appKeys', '');
            $appKeys = explode("\t", $appKeys);
            $map = array();
            foreach ($appKeys as $key => $app) {
                $map[$app] = $dataKeys[$key];
                if ($app == 'start_date' ||
                    $app == 'end_date' ||
                    $app == 'recur_end_date' ||
                    $app == 'alarm_date') {
                    $dates[$dataKeys[$key]]['type'] = 'date';
                    $dates[$dataKeys[$key]]['values'] = array();
                    $i = 0;
                    while ($i < count($importData) && count($dates[$dataKeys[$key]]['values']) < 10) {
                        if ($importData[$i][$dataKeys[$key]] != '') {
                            $dates[$dataKeys[$key]]['values'][] = $importData[$i][$dataKeys[$key]];
                        }
                        $i++;
                    }
                }
                if ($app == 'start_time' ||
                    $app == 'end_time' ||
                    $app == 'alarm_time') {
                    $dates[$dataKeys[$key]]['type'] = 'time';
                    $dates[$dataKeys[$key]]['values'] = array();
                    $i = 0;
                    while ($i < count($importData) && count($dates[$dataKeys[$key]]['values']) < 10) {
                        if ($importData[$i][$dataKeys[$key]] != '') {
                            $dates[$dataKeys[$key]]['values'][] = $importData[$i][$dataKeys[$key]];
                        }
                        $i++;
                    }
                }
            }
            if (count($dates) > 0) {
                $cacheID = $cache->putObject(array($importData, $map));
            }
        }
    } elseif ($importID == IMPORT_DATETIME) {
        include_once HORDE_BASE . '/lib/SessionCache.php';
        $cache = new SessionCache();
        $cacheID = Horde::getFormData('cacheID');
        
        if (!isset($cacheID) || !($tmp = $cache->getObject($cacheID))) {
            $notification->push(_("The data was lost."), 'horde.error');
            $error = true;
        } else {
            $importData = $tmp[0];
            $map = $tmp[1];
            $delimiter = Horde::getFormData('delimiter');
            $format = Horde::getFormData('format');
        }
    }
    
    if ($importID == IMPORT_MAPPED || $importID == IMPORT_DATETIME) {
        if (!$error && count($dates) == 0) {
            $csv = new Data_csv();
            $events = array();
            foreach ($importData as $row) {
                $event = $calendar->getEventObject();
                if (isset($map['title']) && !empty($row[$map['title']])) {
                    $event->setTitle($row[$map['title']]);
                }
                if (isset($map['description']) && !empty($row[$map['description']])) {
                    $event->setDescription($row[$map['description']]);
                }
                if (isset($map['category']) && !empty($row[$map['category']])) {
                    $event->setCategory($row[$map['category']]);
                }
                if (isset($map['location']) && !empty($row[$map['location']])) {
                    $event->setLocation($row[$map['location']]);
                }
                if (isset($map['keywords']) && !empty($row[$map['keywords']])) {
                    $event->setKeywords(explode(',', $row[$map['keywords']]));
                }
                if (isset($map['start_date']) && !empty($row[$map['start_date']])
                    && isset($map['start_time']) && !empty($row[$map['start_time']])) {
                    $dt_arr = array_merge($csv->mapDate($row[$map['start_date']], 'date', $delimiter[$map['start_date']], $format[$map['start_date']]), 
                                          $csv->mapDate($row[$map['start_time']], 'time', $delimiter[$map['start_time']], $format[$map['start_time']]));
                    $event->setStartTimestamp(mktime($dt_arr['hour'], $dt_arr['min'], $dt_arr['sec'], $dt_arr['month'], $dt_arr['mday'], $dt_arr['year']));
                }
                if (isset($map['end_date']) && !empty($row[$map['end_date']])
                    && isset($map['end_time']) && !empty($row[$map['end_time']])) {
                    $dt_arr = array_merge($csv->mapDate($row[$map['end_date']], 'date', $delimiter[$map['end_date']], $format[$map['end_date']]), 
                                          $csv->mapDate($row[$map['end_time']], 'time', $delimiter[$map['end_time']], $format[$map['end_time']]));
                    $event->setEndTimestamp(mktime($dt_arr['hour'], $dt_arr['min'], $dt_arr['sec'], $dt_arr['month'], $dt_arr['mday'], $dt_arr['year']));
                }
                if (isset($map['alarm']) && !empty($row[$map['alarm']])) {
                    $event->setAlarm($row[$map['alarm']]);
                } elseif (isset($map['alarm_date']) && !empty($row[$map['alarm_date']]) &&
                          isset($map['alarm_time']) && !empty($row[$map['alarm_time']])) {
                    $dt_arr = array_merge($csv->mapDate($row[$map['alarm_date']], 'date', $delimiter[$map['alarm_date']], $format[$map['alarm_date']]), 
                                          $csv->mapDate($row[$map['alarm_time']], 'time', $delimiter[$map['alarm_time']], $format[$map['alarm_time']]));
                    $event->setAlarm(($event->getStartTimestamp() - mktime($dt_arr['hour'], $dt_arr['min'], $dt_arr['sec'], $dt_arr['month'], $dt_arr['mday'], $dt_arr['year'])) / 60);
                }
                if (isset($map['recur_type']) && !empty($row[$map['recur_type']])) {
                    $event->setRecurType($row[$map['recur_type']]);
                    if (isset($map['recur_end_date']) && !empty($row[$map['recur_end_date']])) {
                        $dt_arr = $csv->mapDate($row[$map['recur_end_date']], 'date', $delimiter[$map['recur_end_date']], $format[$map['recur_end_date']]);
                        $event->setRecurEndTimestamp(mktime(0, 0, 0, $dt_arr['month'], $dt_arr['mday'], $dt_arr['year']));
                    }
                    if (isset($map['recur_interval']) && !empty($row[$map['recur_interval']])) {
                        $event->setRecurInterval($row[$map['recur_interval']]);
                    }
                    if (isset($map['recur_data']) && !empty($row[$map['recur_data']])) {
                        $event->setRecurOnDay($row[$map['recur_data']]);
                    }
                }
                
                $event->createEvent();
                $eventID = $event->save();
                if ($eventID) {
                    $events[] = $eventID;
                } else {
                    $error = true;
                }
            }

            if ($error) {
                $notification->push(_("There was an error importing the data."), 'horde.error');
            } else {
                $import_type = Horde::getFormData('import_type');
                switch ($import_type) {
                case IMPORT_CSV:
                    $type = 'CSV';
                    break;
                case IMPORT_OUTLOOK:
                    $type = 'Outlook';
                    break;
                case IMPORT_ICALENDAR:
                    $type = 'iCalendar';
                    break;
                }
                $notification->push(sprintf(_("%s file successfully imported"), $type), 'horde.success');
            }

        }
        
    } else {
        if (!isset($HTTP_POST_FILES['import_file']['size']) ||
            !isset($HTTP_POST_FILES['import_file']['tmp_name'])) {
            $notification->push(_("There was a problem with the file upload. The file may have been larger than the maximum allowed size."), 'horde.error');
            $error = true;
        } elseif (!is_uploaded_file($HTTP_POST_FILES['import_file']['tmp_name'])) {
            $notification->push(_("Illegal or malformed form data."), 'horde.error');
            $error = true;
        } elseif ($HTTP_POST_FILES['import_file']['size'] > 0) {
            _fileCleanup($HTTP_POST_FILES['import_file']['tmp_name']);
    
            $header = null;
            switch ($importID) {
            
            case IMPORT_OUTLOOK:
                $header = true;
                
            case IMPORT_CSV:
                $csv = new Data_csv();
                $header = Horde::getFormData('header');
                $importData = $csv->importFile($HTTP_POST_FILES['import_file']['tmp_name'], $header, ',');
                
                if (!isset($importData) || !is_array($importData)) {
                    $notification->push(_("There was an error importing the uploaded file"), 'horde.error');
                    $error = true;
                } else {
                    $actionUrl = Horde::applicationUrl('data.php');
                    
                    $appFields = array('title' => _("Title"),
                                       'start_date' => _("Start Date"),
                                       'start_time' => _("Start Time"),
                                       'end_date' => _("End Date"),
                                       'end_time' => _("End Time"),
                                       'alarm' => _("Alarm Span (minutes)"),
                                       'alarm_date' => _("Alarm Date"),
                                       'alarm_time' => _("Alarm Time"),
                                       'description' => _("Description"),
                                       'category' => _("Category"),
                                       'location' => _("Location"),
                                       'keywords' => _("Keywords"),
                                       'recur_type' => _("Recurrence Type"),
                                       'recur_end_date' => _("Recurrence End Date"),
                                       'recur_interval' => _("Recurrence Interval"),
                                       'recur_data' => _("Recurrence Data"));
                    
                    include_once HORDE_BASE . '/lib/SessionCache.php';
                    $cache = new SessionCache();
                    $cacheID = $cache->putObject(array($importData, $appFields));
                }
                break;
            
            case IMPORT_ICALENDAR:
                $vcs = new Data_rfc2425();
                $data = $vcs->importFile($HTTP_POST_FILES['import_file']['tmp_name']);
                $notification->push(_("iCalendar file successfully imported"), 'horde.success');
                break;
            }
        } else {
            $notification->push(_("The file contained no data."), 'horde.error');
            $error = true;
        }
    }
} elseif ($actionID == HORDE_EXPORT) {
    $exportID = Horde::getFormData('exportID');
    $exportAll = Horde::getFormData('all_events');
    
    if ($exportAll) {
        $events = $calendar->listEvents();
    } else {
        $start->mday = Horde::getFormData('start_day');
        $start->month = Horde::getFormData('start_month');
        $start->year = Horde::getFormData('start_year');
        $end->mday = Horde::getFormData('end_day');
        $end->month = Horde::getFormData('end_month');
        $end->year = Horde::getFormData('end_year');
        $events = $calendar->listEvents($start, $end);
    }
    
    switch ($exportID) {
    case EXPORT_CSV:
        if (count($events) == 0) {
            $notification->push(_("There were no events to export."), 'horde.message');
            $error = true;
        } else {
            $data = array();
            foreach ($events as $id) {
                $event = $calendar->getEventObject($id);
                $row = array();
                $row['title'] = $event->title;
                $row['category'] = $event->category;
                $row['location'] = $event->location;
                $row['description'] = $event->description;
                $row['keywords'] = implode(',', $event->keywords);
                $row['start_date'] = sprintf('%d/%02d/%02d', $event->start->year, $event->start->month, $event->start->mday);
                $row['start_time'] = sprintf('%02d:%02d:%02d', $event->start->hour, $event->start->min, $event->start->sec);
                $row['end_date'] = sprintf('%d/%02d/%02d', $event->end->year, $event->end->month, $event->end->mday);
                $row['end_time'] = sprintf('%02d:%02d:%02d', $event->end->hour, $event->end->min, $event->end->sec);
                $row['alarm'] = $event->alarm;
                $row['recur_type'] = $event->recurType;
                if ($event->recurType != KRONOLITH_RECUR_NONE) {
                    $row['recur_end_date'] = sprintf('%d/%02d/%02d', $event->recurEnd->year, $event->recurEnd->month, $event->recurEnd->mday);
                    $row['recur_interval'] = $event->recurInterval;
                    $row['recur_data'] = $event->recurData;
                } else {
                    $row['recur_end_date'] = null;
                    $row['recur_interval'] = null;
                    $row['recur_data'] = null;
                }
                $data[] = $row;
            }
            
            $csv = new Data_csv();
            $csv->exportFile('kronolith.csv', $data, true);
            exit;
        }
    }
}

$title = _("Import/Export Calendar");
$js_onLoad = null;
require KRONOLITH_TEMPLATES . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';

if ($actionID == NOOP || $error) {
    include KRONOLITH_TEMPLATES . '/data/import.inc';
    include KRONOLITH_TEMPLATES . '/data/export.inc';
} else {
    switch ($importID) {
    case IMPORT_OUTLOOK:
    case IMPORT_CSV:
        include $registry->getParam('templates', 'horde') . '/data/csvmap.inc';
        break;
    
    case IMPORT_MAPPED:
        if (count($dates) > 0) {
            $actionUrl = Horde::applicationUrl('data.php');
            include $registry->getParam('templates', 'horde') . '/data/datemap.inc';
        }
        break;
    
    }

}

$registry->shutdown();
require KRONOLITH_TEMPLATES . '/common-footer.inc';

?>
