<?php
require_once 'Horde/Text.php';
if ($GLOBALS['prefs']->getValue('show_legend') && count($eventCategories)) {
    $html = '<br class="spacer" />';

    $colors = $GLOBALS['cManager']->colors();
    $fgcolors = $GLOBALS['cManager']->fgColors();
    ksort($eventCategories);
    foreach ($eventCategories as $category => $v) {
        if (empty($category)) {
            continue;
        }

        $categoryColor = isset($colors[$category]) ? $colors[$category] : $colors['_default_'];
        $fgColor = isset($fgcolors[$category]) ? $fgcolors[$category] : $fgcolors['_default_'];
        $html .= ' <span class="legend-eventbox event" style="background-color: ' .
            $categoryColor . '; color: ' . $fgColor .'; border-color: ' .
            Kronolith::borderColor($categoryColor) . '">' .
            Text::htmlAllSpaces($category) . '</span>';
    }

    if (Auth::getAuth() && (!$GLOBALS['prefs']->isLocked('categories') ||
                            !$GLOBALS['prefs']->isLocked('category_colors'))) {
        $categoryUrl = Util::addParameter(Horde::url($GLOBALS['registry']->get('webroot', 'horde') . '/services/prefs.php'), array('app' => 'horde', 'group' => 'categories'));
        $html .= ' ' . Horde::link($categoryUrl, _("Edit categories and colors"), '', '_blank') . Horde::img('colorpicker.png', _("Edit categories and colors"), array('align' => 'middle'), $GLOBALS['registry']->getImageDir('horde')) . '</a>';
    }

    echo $html;
}
