<?php
$remote_calendars = unserialize($prefs->getValue('remote_cals'));
$current_user = Auth::getAuth();
$my_calendars = array();
$shared_calendars = array();
foreach (Kronolith::listCalendars() as $id => $cal) {
    if ($cal->get('owner') == $current_user) {
        $my_calendars[$id] = $cal;
    } else {
        $shared_calendars[$id] = $cal;
    }
}
?>

<div id="menu">
<?php if (!$prefs->isLocked('default_share') && ((count($remote_calendars) || count($GLOBALS['all_calendars']) > 1) || !count($GLOBALS['display_calendars']))): ?>
 <span style="float:right">
<?php
if (strstr($_SERVER['PHP_SELF'], 'month.php') !== false ||
    strstr($_SERVER['PHP_SELF'], 'week.php') !== false ||
    strstr($_SERVER['PHP_SELF'], 'workweek.php') !== false ||
    strstr($_SERVER['PHP_SELF'], 'day.php') !== false): ?>
<form action="<?php echo Horde::selfUrl() ?>" method="post" name="calendarSelector">
<?php else: ?>
<form action="<?php echo Horde::applicationUrl($prefs->getValue('defaultview') . '.php') ?>" method="post" name="calendarSelector">
<?php endif; ?>
<?php Util::pformInput() ?>
<input type="hidden" name="timestamp" value="<?php echo Kronolith::currentTimestamp() ?>" />
<select name="display_cal" onchange="calendarSubmit()">
<?php if (count($my_calendars)): ?>
  <option value=""><?php echo _("My Calendars:") ?></option>
<?php foreach ($my_calendars as $id => $cal): ?>
  <option value="<?php echo $id ?>"><?php echo (in_array($id, $display_calendars) ? '+ ' : '&#8211; ') . $cal->get('name') ?></option>
<?php endforeach; ?>
<?php endif; ?>
<?php if (count($shared_calendars)): ?>
  <option value=""><?php echo _("Shared Calendars:") ?></option>
<?php foreach ($shared_calendars as $id => $cal): ?>
  <option value="<?php echo $id ?>"><?php echo (in_array($id, $display_calendars) ? '+ ' : '&#8211; ') . '[' . $cal->get('owner') . '] ' . $cal->get('name') ?></option>
<?php endforeach; ?>
<?php endif; ?>
<?php if (count($remote_calendars)): ?>
  <option value=""><?php echo _("Remote Calendars:") ?></option>
  <?php foreach ($remote_calendars as $id => $cal): ?>
    <option value="remote_<?php echo $cal['url'] ?>"><?php echo (in_array($cal['url'], $display_remote_calendars) ? '+ ' : '&#8211; ') . $cal['name'] ?></option>
  <?php endforeach; ?>
<?php endif; ?>
</select>
</form>
 </span>
 <span style="float:right">
<?php
require_once 'Horde/Menu.php';
$cmenu = &new Menu(HORDE_MENU_MASK_NONE);
$cmenu->add('#', _("_Show"), 'calendars.png', null, null, 'return calendarSubmit()', '__noselection');
echo $cmenu->render();
?>
 </span>
<?php endif; ?>

 <?php echo Kronolith::getMenu('string') ?>
</div>

<script language="JavaScript" type="text/javascript">
<!--
var loading;
function calendarSubmit()
{
    document.calendarSelector.submit();
    return false;
}
// -->
</script>

<br id="menuSpacer" />
<?php $GLOBALS['notification']->notify(array('listeners' => 'status')) ?>
