/***************************************************************************
                          ctagsfrontend.h  -  description
                             -------------------
    begin                : Mon Jun 2 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTAGSFRONTEND_H
#define CTAGSFRONTEND_H

#include <frontend.h>

#define CTAGS_RECORD_SIZE 3

/**
 * Controls a Ctags process for an file in an EditorPage window.
 * A new Ctags process is run each time the file in the editor window is
 * loaded (including the initial load, and any subsequent ones which follow a
 * 'save' operation.)
 * The output of the process is parsed into a set of records, each composed of
 * the following fields:
 * - Tag type
 * - Tag name
 * - Line number
 * The records are then displayed in the CtagsList widget that is attached to
 * each EditorPage window.
 * @author Elad Lahav
 */

class CtagsFrontend : public Frontend
{
   Q_OBJECT

public:
	CtagsFrontend();
	~CtagsFrontend();

	bool run(const QString&);
	
	static bool verify(const QString&);

protected:
	virtual ParseResult parseStdout(QString&, ParserDelim);

private:
	/** State values for the parser state machine. */
	enum ParserState { Name = 0, File, Line, Type, Other };

	/** The current state of the parser state machine. */
	ParserState m_state;
};

#endif
