/***************************************************************************
                          ctagslist.h  -  description
                             -------------------
    begin                : Mon Jun 2 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTAGSLIST_H
#define CTAGSLIST_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qmemarray.h>
#include "searchlist.h"
#include "frontend.h"

class CtagsListItem;

/**
 * Displays a list of tags for a source file.
 * The list is embedded inside an editor page. Whenever a new document is
 * opened in that editor, or the current document is changed and saved, the
 * source file is re-scanned for tags, and the results are displayed in this
 * list.
 * @author Elad Lahav
 */

class CtagsList : public SearchList
{
   Q_OBJECT

public:
	CtagsList(QWidget* pParent = 0, const char* szName = 0);
	~CtagsList();

	void applyPrefs();
	void gotoLine(uint);
	void clear();
	
public slots:
	void slotDataReady(FrontendToken*);
	void slotCtagsFinished(uint);
	
signals:
	/** 
	 * Emitted when the size of the list is changed (usually as the result
	 * of moving the separator between the list and the editor.)
	 */
	void resized();
	
	/**
	 * Emitted when the user selects a tag item from the list.
	 * @param	nLine	The line number associated with the selected tag
	 */
	void lineRequested(uint nLine);
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual void processItemSelected(QListViewItem*);

private:
	/** An array of pointers to the tag list items, sorted by the line
		number. */
	QMemArray<CtagsListItem*> m_arrLines;
	
	/** The number of items in the tag list. */
	uint m_nItems;
	
	/** The last item selected by gotoLine(). */
	uint m_nCurItem;
	
	/** This value is set to 'false' while the Ctags process is running. */
	bool m_bReady;
	
	/** The current line number. */
	uint m_nCurLine;
	
	/** Stores the requested line number during Ctags operation. */
	uint m_nPendLine;

private slots:
	void slotSortChanged(int);
};

#endif
